package com.ultreon.devices.core.io.task;

import com.ultreon.devices.api.io.Folder;
import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.ServerFile;
import com.ultreon.devices.core.io.ServerFolder;
import com.ultreon.devices.core.io.drive.AbstractDrive;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

/**
 * @author MrCrayfish
 */
public class TaskGetFiles extends Task {
    private String uuid;
    private String path;
    private class_2338 pos;

    private List<ServerFile> files;

    public TaskGetFiles() {
        super("get_files");
    }

    public TaskGetFiles(Folder folder, class_2338 pos) {
        this();
        this.uuid = folder.getDrive().getUUID().toString();
        this.path = folder.getPath();
        this.pos = pos;
    }

    protected static String compileDirectory(ServerFile file) {
        if (file.getParent() == null || file.getParent().getParent() == null) return "/";

        StringBuilder builder = new StringBuilder();
        ServerFolder parent = file.getParent();
        while (parent != null) {
            builder.insert(0, "/" + parent.getName());
            if (parent.getParent() != null) {
                return builder.toString();
            }
            parent = parent.getParent();
        }
        return builder.toString();
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10582("uuid", uuid);
        tag.method_10582("path", path);
        tag.method_10544("pos", pos.method_10063());
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092(tag.method_10537("pos"))).method_12201(class_2338.method_10092(tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof LaptopBlockEntity laptop) {
            FileSystem fileSystem = laptop.getFileSystem();
            UUID uuid = UUID.fromString(tag.method_10558("uuid"));
            AbstractDrive serverDrive = fileSystem.getAvailableDrives(level, true).get(uuid);
            if (serverDrive != null) {
                ServerFolder found = serverDrive.getFolder(tag.method_10558("path"));
                if (found != null) {
                    this.files = found.getFiles().stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
                    this.setSuccessful();
                }
            }
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.files != null) {
            class_2499 list = new class_2499();
            this.files.forEach(f -> {
                CompoundTag fileTag = new CompoundTag();
                fileTag.putString("file_name", f.getName());
                fileTag.put("data", f.toTag());
                list.add(fileTag);
            });
            tag.method_10566("files", list);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {

    }
}
