package com.ultreon.devices.core.io.task;

import com.ultreon.devices.api.io.Drive;
import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.action.FileAction;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

/**
 * @author MrCrayfish
 */
public class TaskSendAction extends Task {
    private String uuid;
    private FileAction action;
    private class_2338 pos;

    private FileSystem.Response response;

    public TaskSendAction() {
        super("send_action");
    }

    public TaskSendAction(Drive drive, FileAction action) {
        this();
        this.uuid = drive.getUUID().toString();
        this.action = action;
        this.pos = Laptop.getPos();
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10582("uuid", uuid);
        tag.method_10566("action", action.toTag());
        tag.method_10544("pos", pos.method_10063());
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        FileAction action = FileAction.fromTag(tag.method_10562("action"));
        class_2586 tileEntity = level.method_8500(class_2338.method_10092(tag.method_10537("pos"))).method_12201(class_2338.method_10092(tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof LaptopBlockEntity laptop) {
            response = laptop.getFileSystem().readAction(tag.method_10558("uuid"), action, level);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        tag.method_10566("response", response.toTag());
    }

    @Override
    public void processResponse(class_2487 tag) {

    }
}
