package com.ultreon.devices.core.io.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.LaptopBlockEntity;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.core.io.drive.AbstractDrive;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

/**
 * @author MrCrayfish
 */
public class TaskSetupFileBrowser extends Task {
    private class_2338 pos;
    private boolean includeMain;

    private AbstractDrive mainDrive;
    private Map<UUID, AbstractDrive> availableDrives;

    public TaskSetupFileBrowser() {
        super("get_file_system");
    }

    public TaskSetupFileBrowser(class_2338 pos, boolean includeMain) {
        this();
        this.pos = pos;
        this.includeMain = includeMain;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10544("pos", pos.method_10063());
        tag.method_10556("include_main", includeMain);
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092(tag.method_10537("pos"))).method_12201(class_2338.method_10092(tag.method_10537("pos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof LaptopBlockEntity laptop) {
            FileSystem fileSystem = laptop.getFileSystem();
            if (tag.method_10577("include_main")) {
                mainDrive = fileSystem.getMainDrive();
            }
            availableDrives = fileSystem.getAvailableDrives(level, false);
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.isSucessful()) {
            if (mainDrive != null) {
                class_2487 mainDriveTag = new class_2487();
                mainDriveTag.method_10582("name", mainDrive.getName());
                mainDriveTag.method_10582("uuid", mainDrive.getUuid().toString());
                mainDriveTag.method_10582("type", mainDrive.getType().toString());
                tag.method_10566("main_drive", mainDriveTag);
                tag.method_10566("structure", mainDrive.getDriveStructure().toTag());
            }

            class_2499 driveList = new class_2499();
            availableDrives.forEach((k, v) -> {
                class_2487 driveTag = new class_2487();
                driveTag.method_10582("name", v.getName());
                driveTag.method_10582("uuid", v.getUuid().toString());
                driveTag.method_10582("type", v.getType().toString());
                driveList.add(driveTag);
            });
            tag.method_10566("available_drives", driveList);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {

    }
}
