package com.ultreon.devices.core.laptop.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import com.ultreon.devices.Devices;
import com.ultreon.devices.Reference;
import com.ultreon.devices.core.laptop.common.C2SUpdatePacket;
import com.ultreon.devices.core.laptop.common.TaskBar;
import com.ultreon.devices.core.laptop.server.ServerLaptop;
import com.ultreon.devices.network.PacketHandler;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;

import static com.ultreon.devices.core.laptop.client.ClientLaptopScreen.LAPTOP_GUI;
import static net.minecraft.class_332.method_25293;


// NO STATICS
public class ClientLaptop {
    public static final HashMap<UUID, ClientLaptop> laptops = new HashMap<>(); // current active client laptops
    public static final int DEVICE_HEIGHT = 216;
    public static final int SCREEN_HEIGHT = DEVICE_HEIGHT - 20;
    public static final int DEVICE_WIDTH = 384;
    public static final int SCREEN_WIDTH = DEVICE_WIDTH - 20;

    private UUID uuid;
    public final double[] square = new double[2];

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    private TaskBar taskbar = new TaskBar(this);
    public ClientLaptop() {
        //super(Component.translatable("laptop")); //todo
    }

    public void handlePacket(String type, class_2487 nbt) {
        if (type.equals("placeSquare")) {
            System.out.println("moving square lol");
            System.out.println(nbt);
            square[0] = nbt.method_10574("x");
            square[1] = nbt.method_10574("y");
            System.out.println("SET");
        }
    }

    public void sendPacket(String type, class_2487 nbt) {
        System.out.printf("Sending packet %s, %s%n", type, nbt);
        PacketHandler.sendToServer(new C2SUpdatePacket(this.uuid, type, nbt));
    }

    public void renderBezels(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) { // no bezels

    }

    //@Override
    public void render(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        double[] square = new double[2];
        class_310.method_1551().method_18859(() -> {
            square[0] = this.square[0];
            square[1] = this.square[1];
        });
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, LAPTOP_GUI);
        //RenderSystem.disableBlend();
        class_329.method_25293(pose, 0, 0, ClientLaptop.SCREEN_WIDTH, ClientLaptop.SCREEN_HEIGHT, 10, 10, 1, 1, 256, 256);
        //RenderSystem.enableBlend();

        class_310.method_1551().field_1772.method_1729(pose, "New Laptop System 0.01% complete", 0, 0, 0xffffff);
        class_329.method_25294(pose, 0, 0, 10, 10, 0x2e2e2e);
        taskbar.render(pose, this, class_310.method_1551(), 0, SCREEN_HEIGHT-16, mouseX, mouseY, partialTicks);
        System.out.println("x = " + square[0]);
        class_329.method_25294(pose, (int) square[0], (int) square[1], (int) square[0]+10, (int) square[1]+10, 0xffffff);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        var nbt = new class_2487();
        nbt.method_10549("x", mouseX);
        nbt.method_10549("y", mouseY);
        sendPacket("mouseMoved", nbt);
    }

    public UUID getUuid() {
        return uuid;
    }
}
