package com.ultreon.devices.core.laptop.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Reference;
import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_4587;


public class ClientLaptopScreen extends class_437 {
    static final class_2960 LAPTOP_GUI = new class_2960(Reference.MOD_ID, "textures/gui/laptop.png");
    private static final int BORDER = 10;
    private final ClientLaptop laptop;


    public ClientLaptopScreen(ClientLaptop laptop) {
        super(class_2561.method_43471(laptop.toString()));
        this.laptop = laptop;
    }

    public void renderBezels(final @NotNull class_4587 pose, final int mouseX, final int mouseY, float partialTicks) {
        this.method_25420(pose);

        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        RenderSystem.setShaderTexture(0, LAPTOP_GUI);

        //*************************//
        //     Physical Screen     //
        //*************************//
        int posX = (field_22789 - ClientLaptop.DEVICE_WIDTH) / 2;
        int posY = (field_22790 - ClientLaptop.DEVICE_HEIGHT) / 2;

        // Corners
        method_25302(pose, posX, posY, 0, 0, BORDER, BORDER); // TOP-LEFT
        method_25302(pose, posX + ClientLaptop.DEVICE_WIDTH - BORDER, posY, 11, 0, BORDER, BORDER); // TOP-RIGHT
        method_25302(pose, posX + ClientLaptop.DEVICE_WIDTH - BORDER, posY + ClientLaptop.DEVICE_HEIGHT - BORDER, 11, 11, BORDER, BORDER); // BOTTOM-RIGHT
        method_25302(pose, posX, posY + ClientLaptop.DEVICE_HEIGHT - BORDER, 0, 11, BORDER, BORDER); // BOTTOM-LEFT

        // Edges
        class_329.method_25293(pose, posX + BORDER, posY, ClientLaptop.SCREEN_WIDTH, BORDER, 10, 0, 1, BORDER, 256, 256); // TOP
        class_329.method_25293(pose, posX + ClientLaptop.DEVICE_WIDTH - BORDER, posY + BORDER, BORDER, ClientLaptop.SCREEN_HEIGHT, 11, 10, BORDER, 1, 256, 256); // RIGHT
        class_329.method_25293(pose, posX + BORDER, posY + ClientLaptop.DEVICE_HEIGHT - BORDER, ClientLaptop.SCREEN_WIDTH, BORDER, 10, 11, 1, BORDER, 256, 256); // BOTTOM
        class_329.method_25293(pose, posX, posY + BORDER, BORDER, ClientLaptop.SCREEN_HEIGHT, 0, 11, BORDER, 1, 256, 256); // LEFT

        // Center
        class_329.method_25293(pose, posX + BORDER, posY + BORDER, ClientLaptop.SCREEN_WIDTH, ClientLaptop.SCREEN_HEIGHT, 10, 10, 1, 1, 256, 256);

    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        int posX = (field_22789 - ClientLaptop.DEVICE_WIDTH) / 2 + BORDER;
        int posY = (field_22790 - ClientLaptop.DEVICE_HEIGHT) / 2 + BORDER;
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        renderBezels(poseStack, mouseX, mouseY, partialTick);
        poseStack.method_22904(posX, posY, 0);
        laptop.render(poseStack, mouseX-posX, mouseY-posY, partialTick);
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        int posX = (field_22789 - ClientLaptop.DEVICE_WIDTH) / 2 + BORDER;
        int posY = (field_22790 - ClientLaptop.DEVICE_HEIGHT) / 2 + BORDER;
        super.method_16014(mouseX, mouseY);
        laptop.mouseMoved(mouseX-posX, mouseY-posY);
        System.out.println(Arrays.toString(laptop.square));
    }
}
