package com.ultreon.devices.core.laptop.common;

import com.ultreon.devices.core.laptop.client.ClientLaptop;
import com.ultreon.devices.core.laptop.server.ServerLaptop;
import com.ultreon.devices.network.Packet;
import dev.architectury.networking.NetworkManager;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import java.util.UUID;
import java.util.function.Supplier;

public class C2SUpdatePacket extends Packet<C2SUpdatePacket> {
    private final class_2487 nbt;

    public C2SUpdatePacket(UUID laptop, String type, class_2487 nbt) {
        this.nbt = new class_2487();
        this.nbt.method_25927("uuid", laptop); // laptop uuid
        this.nbt.method_10582("type", type);
        this.nbt.method_10566("data", nbt);
    }

    @Deprecated // do not call
    public C2SUpdatePacket(class_2540 buf) {
        this.nbt = buf.method_10798();
    }
    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10794(nbt);
    }

    @Override
    public boolean onMessage(Supplier<NetworkManager.PacketContext> ctx) {
        if (ctx.get().getEnv().equals(EnvType.SERVER)) {
            ServerLaptop.laptops.get(this.nbt.method_25926("uuid")).handlePacket(ctx.get().getPlayer(), this.nbt.method_10558("type"), this.nbt.method_10562("data"));
        }
        return false;
    }
}
