package com.ultreon.devices.core.network;

import com.ultreon.devices.block.entity.RouterBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class Connection {
    private UUID routerId;
    private class_2338 routerPos;

    private Connection() {

    }

    public Connection(Router router) {
        this.routerId = router.getId();
        this.routerPos = router.getPos();
    }

    public UUID getRouterId() {
        return routerId;
    }

    @Nullable
    public class_2338 getRouterPos() {
        return routerPos;
    }

    public void setRouterPos(@Nullable class_2338 routerPos) {
        this.routerPos = routerPos;
    }

    @Nullable
    public Router getRouter(@NotNull class_1937 level) {
        if (routerPos == null)
            return null;

        class_2586 blockEntity = level.method_8321(routerPos);
        if (blockEntity instanceof RouterBlockEntity router) {
            if (router.getRouter().getId().equals(routerId)) {
                return router.getRouter();
            }
        }
        return null;
    }

    public boolean isConnected() {
        return routerPos != null;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("id", routerId.toString());
        return tag;
    }

    public static Connection fromTag(class_2487 tag) {
        Connection connection = new Connection();
        connection.routerId = UUID.fromString(tag.method_10558("id"));
        return connection;
    }
}
