package com.ultreon.devices.core.network;

import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.core.Device;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class NetworkDevice extends Device {
    private NetworkDevice() {
        super();
    }

    public NetworkDevice(NetworkDeviceBlockEntity device) {
        super(device);
    }

    public NetworkDevice(@NotNull UUID id, @NotNull String name, @NotNull Router router) {
        super(id, name);
    }

    public boolean isConnected(class_1937 level) {
        if (pos == null) {
            return false;
        }

        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity device) {
            Router router = device.getRouter();
            return router != null && router.getId().equals(this.getId());
        }
        return false;
    }

    @Nullable
    @Override
    public NetworkDeviceBlockEntity getDevice(@NotNull class_1937 level) {
        if (pos == null)
            return null;

        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof NetworkDeviceBlockEntity device) {
            return device;
        }
        return null;
    }

    @Override
    public class_2487 toTag(boolean includePos) {
        class_2487 tag = super.toTag(includePos);
        if (includePos && pos != null) {
            tag.method_10544("pos", pos.method_10063());
        }
        return tag;
    }

    public static NetworkDevice fromTag(class_2487 tag) {
        NetworkDevice device = new NetworkDevice();
        device.id = UUID.fromString(tag.method_10558("id"));
        device.name = tag.method_10558("name");

        if (tag.method_10573("pos", class_2520.field_33254)) {
            device.pos = class_2338.method_10092(tag.method_10537("pos"));
        }
        return device;
    }
}
