package com.ultreon.devices.core.network;

import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;

public class Router {
    private final Map<UUID, NetworkDevice> NETWORK_DEVICES = new HashMap<>();

    private int timer;
    private UUID routerId;
    private class_2338 pos;

    public Router(class_2338 pos) {
        this.pos = pos;
    }

    public void tick(class_1937 level) {
        if (++timer >= DeviceConfig.BEACON_INTERVAL.get()) {
            sendBeacon(level);
            timer = 0;
        }
    }

    public boolean addDevice(UUID id, String name) {
        if (NETWORK_DEVICES.size() >= DeviceConfig.MAX_DEVICES.get()) {
            return NETWORK_DEVICES.containsKey(id);
        }
        if (!NETWORK_DEVICES.containsKey(id)) {
            NETWORK_DEVICES.put(id, new NetworkDevice(id, name, this));
        }
        timer = DeviceConfig.BEACON_INTERVAL.get();
        return true;
    }

    public boolean addDevice(NetworkDeviceBlockEntity device) {
        if (NETWORK_DEVICES.size() >= DeviceConfig.MAX_DEVICES.get()) {
            return NETWORK_DEVICES.containsKey(device.getId());
        }
        if (!NETWORK_DEVICES.containsKey(device.getId())) {
            NETWORK_DEVICES.put(device.getId(), new NetworkDevice(device));
        }
        return true;
    }

    public boolean isDeviceRegistered(NetworkDeviceBlockEntity device) {
        return NETWORK_DEVICES.containsKey(device.getId());
    }

    public boolean isDeviceConnected(NetworkDeviceBlockEntity device) {
        return isDeviceRegistered(device) && NETWORK_DEVICES.get(device.getId()).getPos() != null;
    }

    public void removeDevice(NetworkDeviceBlockEntity device) {
        NETWORK_DEVICES.remove(device.getId());
    }

    @Nullable
    public NetworkDeviceBlockEntity getDevice(class_1937 level, UUID id) {
        return NETWORK_DEVICES.containsKey(id) ? NETWORK_DEVICES.get(id).getDevice(level) : null;
    }

    public Collection<NetworkDevice> getNetworkDevices() {
        return NETWORK_DEVICES.values();
    }

    public Collection<NetworkDevice> getConnectedDevices(class_1937 level) {
        sendBeacon(level);
        return NETWORK_DEVICES.values().stream().filter(device -> device.getPos() != null).toList();
    }

    public Collection<NetworkDevice> getConnectedDevices(final class_1937 level, Class<? extends NetworkDeviceBlockEntity> type) {
        final Predicate<NetworkDevice> DEVICE_TYPE = networkDevice -> {
            if (networkDevice.getPos() == null)
                return false;

            class_2586 blockEntity = level.method_8321(networkDevice.getPos());
            if (blockEntity instanceof NetworkDeviceBlockEntity device) {
                return type.isAssignableFrom(device.getClass());
            }
            return false;
        };
        return getConnectedDevices(level).stream().filter(DEVICE_TYPE).toList();
    }

    private void sendBeacon(class_1937 level) {
        if (level.field_9236)
            return;

        NETWORK_DEVICES.forEach((uuid, device) -> device.setPos(null));
        int range = DeviceConfig.SIGNAL_RANGE.get();
        for (int x = -range; x <= range; x++) {
            for (int y = -range; y <= range; y++) {
                for (int z = -range; z <= range; z++) {
                    class_2338 currentPos = new class_2338(pos.method_10263() + x, pos.method_10264() + y, pos.method_10260() + z);
                    class_2586 blockEntity = level.method_8321(currentPos);
                    if (blockEntity instanceof NetworkDeviceBlockEntity device) {
                        if (!NETWORK_DEVICES.containsKey(device.getId()))
                            continue;
                        if (device.receiveBeacon(this)) {
                            NETWORK_DEVICES.get(device.getId()).setPos(currentPos);
                        }
                    }
                }
            }
        }
    }

    public UUID getId() {
        if (routerId == null) {
            routerId = UUID.randomUUID();
        }
        return routerId;
    }

    public class_2338 getPos() {
        return pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public class_2487 toTag(boolean includePos) {
        class_2487 tag = new class_2487();
        tag.method_25927("id", getId());

        class_2499 deviceList = new class_2499();
        NETWORK_DEVICES.forEach((id, device) -> {
            deviceList.add(device.toTag(includePos));
        });
        tag.method_10566("network_devices", deviceList);

        return tag;
    }

    public static Router fromTag(class_2338 pos, class_2487 tag) {
        Router router = new Router(pos);
        router.routerId = tag.method_25926("id");

        class_2499 deviceList = tag.method_10554("network_devices", 10);
        for (int i = 0; i < deviceList.size(); i++) {
            NetworkDevice device = NetworkDevice.fromTag(deviceList.method_10602(i));
            router.NETWORK_DEVICES.put(device.getId(), device);
        }
        return router;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj instanceof Router router))
            return false;
        return router.getId().equals(getId());
    }
}
