package com.ultreon.devices.core.network.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.block.entity.RouterBlockEntity;
import com.ultreon.devices.core.network.Router;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

/**
 * @author MrCrayfish
 */
public class TaskConnect extends Task {
    private class_2338 devicePos;
    private class_2338 routerPos;

    public TaskConnect() {
        super("connect");
    }

    public TaskConnect(class_2338 devicePos, class_2338 routerPos) {
        this();
        this.devicePos = devicePos;
        this.routerPos = routerPos;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10544("devicePos", devicePos.method_10063());
        tag.method_10544("routerPos", routerPos.method_10063());
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2586 tileEntity = level.method_8500(class_2338.method_10092(tag.method_10537("routerPos"))).method_12201(class_2338.method_10092(tag.method_10537("routerPos")), class_2818.class_2819.field_12860);
        if (tileEntity instanceof RouterBlockEntity tileEntityRouter) {
            Router router = tileEntityRouter.getRouter();

            class_2586 tileEntity1 = level.method_8500(class_2338.method_10092(tag.method_10537("devicePos"))).method_12201(class_2338.method_10092(tag.method_10537("devicePos")), class_2818.class_2819.field_12860);
            if (tileEntity1 instanceof NetworkDeviceBlockEntity tileEntityNetworkDevice) {
                if (router.addDevice(tileEntityNetworkDevice)) {
                    tileEntityNetworkDevice.connect(router);
                    this.setSuccessful();
                }
            }
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {

    }

    @Override
    public void processResponse(class_2487 tag) {

    }
}
