package com.ultreon.devices.core.network.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.core.network.NetworkDevice;
import com.ultreon.devices.core.network.Router;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2818;

/**
 * @author MrCrayfish
 */
public class TaskGetDevices extends Task {
    private class_2338 devicePos;
    private Class<? extends NetworkDeviceBlockEntity> targetDeviceClass;

    private Collection<NetworkDevice> foundDevices;

    public TaskGetDevices() {
        super("get_network_devices");
    }

    public TaskGetDevices(class_2338 devicePos) {
        this();
        this.devicePos = devicePos;
    }

    public TaskGetDevices(class_2338 devicePos, Class<? extends NetworkDeviceBlockEntity> targetDeviceClass) {
        this();
        this.devicePos = devicePos;
        this.targetDeviceClass = targetDeviceClass;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10544("devicePos", devicePos.method_10063());
        if (targetDeviceClass != null) {
            tag.method_10582("targetClass", targetDeviceClass.getName());
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        class_2338 devicePos = class_2338.method_10092(tag.method_10537("devicePos"));
        Class<? extends NetworkDeviceBlockEntity> targetDeviceClass = null;
        try {
            Class<?> targetClass = Class.forName(tag.method_10558("targetClass"));
            if (NetworkDeviceBlockEntity.class.isAssignableFrom(targetClass)) {
                targetDeviceClass = (Class<? extends NetworkDeviceBlockEntity>) targetClass;
            }
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }

        class_2586 tileEntity = level.method_8500(devicePos).method_12201(devicePos, class_2818.class_2819.field_12860);
        if (tileEntity instanceof NetworkDeviceBlockEntity tileEntityNetworkDevice) {
            if (tileEntityNetworkDevice.isConnected()) {
                Router router = tileEntityNetworkDevice.getRouter();
                if (router != null) {
                    if (targetDeviceClass != null) {
                        foundDevices = router.getConnectedDevices(level, targetDeviceClass);
                    } else {
                        foundDevices = router.getConnectedDevices(level);
                    }
                    this.setSuccessful();
                }
            }
        }
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        if (this.isSucessful()) {
            class_2499 deviceList = new class_2499();
            foundDevices.forEach(device -> deviceList.add(device.toTag(true)));
            tag.method_10566("network_devices", deviceList);
        }
    }

    @Override
    public void processResponse(class_2487 tag) {

    }
}
