package com.ultreon.devices.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ultreon.devices.init.DeviceItems;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1074;
import net.minecraft.class_1076;
import net.minecraft.class_1767;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DevicesLanguageGenerator extends FabricLanguageProvider {
    private final String languageCode;
    protected DevicesLanguageGenerator(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
        this.languageCode = "en_us";
        l = new class_1076(this.languageCode);
    }

    protected DevicesLanguageGenerator(FabricDataGenerator dataGenerator, String languageCode) {
        super(dataGenerator, languageCode);
        this.languageCode = languageCode;
        l = new class_1076(this.languageCode);
    }
    private final class_1076 l;

    @Override
    public void generateTranslations(TranslationBuilder translationBuilder) {
        if (this.languageCode.equals("en_pt")) {
            createTranslationsForPirateSpeak(translationBuilder);
        } else if (this.languageCode.startsWith("en_")) { // engurishu
            createTranslationsForEnglish(translationBuilder);
        } else if (this.languageCode.startsWith("nl_")) { // dutch
            //createTranslationsForDutch(translationBuilder);
        } else if (this.languageCode.equals("lol_us")) { // lolcat
            createTranslationsForLOLCAT(translationBuilder);
        } else if (this.languageCode.startsWith("ja_")) {
            createTranslationsForJapanese(translationBuilder);
        }
    }

    private void createTranslationsForPirateSpeak(TranslationBuilder translationBuilder) {
        createTranslationsFromTemplate(translationBuilder, "en_pt");
    }

    private void createTranslationsForJapanese(TranslationBuilder translationBuilder) {
        createTranslationsFromTemplate(translationBuilder, "ja");
    }

    private JsonObject getJSON(Path path) {
        try {
            FileInputStream d = new FileInputStream(path.toFile());
            var json = new Gson().fromJson(IOUtils.toString(d, StandardCharsets.UTF_8), JsonObject.class);
            if (!path.endsWith("en.json")) {
                var eng = getJSON(dataGenerator.getModContainer().findPath("translations/en.json").get());
                for (String s : eng.keySet()) {
                    if (!json.has(s)) {
                        eng.add(s, eng.get(s));
                    }
                }
            }
            return json;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createTranslationsFromTemplate(TranslationBuilder translationBuilder, String file) {
        @NotNull
        var pathode = getJSON(dataGenerator.getModContainer().findPath("translations/" + file + ".json").get());

        DeviceItems.LAPTOPS.getMap().forEach((dye, item) -> {
            var laptop = pathode.get("laptop").getAsString();
            var laptop_block = String.format(pathode.get("laptop_block").getAsString(), laptop,get(dye));
            translationBuilder.add(item.get().method_7876(), laptop_block);
        });

        DeviceItems.PRINTERS.getMap().forEach((dye, item) -> {
            var printer = pathode.get("printer").getAsString();
            var printer_block = String.format(pathode.get("printer_block").getAsString(), printer,get(dye));
            translationBuilder.add(item.get().method_7876(), printer_block);
        });

        DeviceItems.FLASH_DRIVE.getMap().forEach((dye, item) -> {
            var flash_drive = pathode.get("flash_drive").getAsString();
            var flash_drive_item = String.format(pathode.get("flash_drive_item").getAsString(), flash_drive,get(dye));
            translationBuilder.add(item.get().method_7876(), flash_drive_item);
        });

        DeviceItems.ROUTERS.getMap().forEach((dye, item) -> {
            var router = pathode.get("router").getAsString();
            var router_block = String.format(pathode.get("router_block").getAsString(), router, get(dye));
            translationBuilder.add(item.get().method_7876(), router_block);
        });

        DeviceItems.OFFICE_CHAIRS.getMap().forEach((dye, item) -> {
            var office_chair = pathode.get("office_chair").getAsString();
            var office_chair_block = String.format(pathode.get("office_chair_block").getAsString(), office_chair, get(dye));
            translationBuilder.add(item.get().method_7876(), office_chair_block);
        });
    }

    private void createTranslationsForLOLCAT(TranslationBuilder translationBuilder) {
        createTranslationsFromTemplate(translationBuilder, "lol");
    }

    private void createTranslationsForDutch(TranslationBuilder translationBuilder) { // TODO: @Qboi123
        createTranslationsFromTemplate(translationBuilder, "nl_nl");
    }

    private void createTranslationsForEnglish(TranslationBuilder translationBuilder) {
        //System.out.println(dataGenerator.getModContainer().getRootPaths());
        try {
            translationBuilder.add(dataGenerator.getModContainer().findPath("en_us_existing.json").orElseThrow());
        } catch (Exception e) {e.printStackTrace();}
        createTranslationsFromTemplate(translationBuilder, "en");
    }
    
    private String get(class_1767 dye) {
        if(differentLanguageCode()) {
            return grabIt("color.minecraft." + dye.method_7792());
        }
        return class_1074.method_4662("color.minecraft." + dye.method_7792());
    }

    private String grabIt(String key) {
        try {
            String string = String.format("/assets/minecraft/lang/%s.json", this.languageCode);
            var d = Paths.get("lang/" + this.languageCode + ".json").toFile();
            var q = new BufferedReader(new FileReader(d));
            var gg = new Gson().fromJson(q, JsonObject.class);
            return gg.get(key).getAsString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean differentLanguageCode() {
        return !this.languageCode.startsWith("en_") && !this.languageCode.equals("en_pt");
    }
}
