package com.ultreon.devices.datagen;

import com.ultreon.devices.init.DeviceBlocks;
import dev.architectury.registry.registries.RegistrySupplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1767;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import java.util.function.Consumer;

public class DevicesRecipeProvider extends FabricRecipeProvider {
    public DevicesRecipeProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    protected void generateRecipes(Consumer<class_2444> exporter) {
        DeviceBlocks.LAPTOPS.getMap().forEach(((dyeColor, blockRegistrySupplier) -> {
            laptop(exporter, blockRegistrySupplier.get(), dyeColor);
        }));
    }

    public static void laptop(Consumer<class_2444> finishedRecipeConsumer, class_1935 laptop, class_1767 color) {
        class_2447.method_10437(laptop)
                .method_10434('+', DyeUtils.getWoolFromDye(color))
                .method_10434('#', class_1802.field_22020)
                .method_10434('|', class_1802.field_8155)
                .method_10434('_', class_1802.field_8668)
                .method_10434('$', class_1802.field_8280)
                .method_10439("#+#")
                .method_10439("$|$")
                .method_10439("_|_").method_10435("devices:laptop")
                .method_10429(getHasName(class_1802.field_22020), has(class_1802.field_22020))
                .unlockedBy(getHasName(class_1802.field_8155), has(class_1802.field_8155))
                .unlockedBy(getHasName(class_1802.field_8668), has(class_1802.field_8668))
     //         .unlockedBy(getHasName(Items.GLASS), has(Items.GLASS))
                .save(finishedRecipeConsumer);
    }
}
