package com.ultreon.devices.event;

import com.ultreon.devices.api.WorldSavedData;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_5218;
//TODO
public class WorldDataHandler {
    private static final class_5218 DEVICES_MOD_DATA = new class_5218("data/devices-mod");

//    @SubscribeEvent
//    public void load(final LifecycleEvent.START event) {
////        LifecycleEvent.SERVER_STARTING;
//        final File modData = Objects.requireNonNull(event.getServer(), "World loaded without server").getWorldPath(DEVICES_MOD_DATA).toFile();
//        if (!modData.exists()) {
//            try {
//                Files.createDirectories(modData.toPath());
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
//        }
//
//        loadData(modData, "emails.dat", EmailManager.INSTANCE);
//        loadData(modData, "bank.dat", BankUtil.INSTANCE);
//    }

//    @SubscribeEvent
//    public void save(final WorldEvent.Save event) {
//        LifecycleEvent.SERVER_LEVEL_SAVE
//        final MinecraftServer server = event.getWorld().getServer();
//        if (server == null) {
//            if (event.getWorld().getLevelData() instanceof ServerLevelData serverLevelData)
//                DevicesMod.LOGGER.warn("World {} saved without server", serverLevelData.getLevelName());
//            else
//                DevicesMod.LOGGER.warn("World saved without server");
//            return;
//        }
//        File modData = server.getWorldPath(DEVICES_MOD_DATA).toFile();
//        if (!modData.exists()) {
//            try {
//                Files.createDirectories(modData.toPath());
//            } catch (IOException e) {
//                throw new RuntimeException(e);
//            }
//        }
//
//        saveData(modData, "emails.dat", EmailManager.INSTANCE);
//        saveData(modData, "bank.dat", BankUtil.INSTANCE);
//    }

    private void loadData(File modData, String fileName, WorldSavedData data) {
        File dataFile = new File(modData, fileName);
        if (!dataFile.exists()) {
            return;
        }
        try {
            class_2487 nbt = class_2507.method_30613(dataFile);
            data.load(nbt);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveData(File modData, String fileName, WorldSavedData data) {
        try {
            File dataFile = new File(modData, fileName);
            if (!dataFile.exists()) {
                Files.createFile(dataFile.toPath());
            }

            class_2487 nbt = new class_2487();
            data.save(nbt);
            class_2507.method_30614(nbt, dataFile);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
