package com.ultreon.devices.init;

import com.ultreon.devices.Devices;
import com.ultreon.devices.block.*;
import com.ultreon.devices.util.DyeableRegistration;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2378;

public class DeviceBlocks {
    private static final Registrar<class_2248> REGISTER = Devices.REGISTRIES.get().get(class_2378.field_25105);


    public static void register() {
    }

    public static final DyeableRegistration<class_2248> LAPTOPS = new DyeableRegistration<>() {
        @Override
        public RegistrySupplier<class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_laptop"), () -> new LaptopBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };

    public static final DyeableRegistration<class_2248> PRINTERS = new DyeableRegistration<>() {
        @Override
        public RegistrySupplier<class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_printer"), () -> new PrinterBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };

    public static final DyeableRegistration<class_2248> ROUTERS = new DyeableRegistration<>() {
        @Override
        public RegistrySupplier<class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_router"), () -> new RouterBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };

    public static final DyeableRegistration<class_2248> OFFICE_CHAIRS = new DyeableRegistration<>() {
        @Override
        public RegistrySupplier<class_2248> register(Registrar<class_2248> registrar, class_1767 color) {
            return registrar.register(Devices.id(color.method_7792() + "_office_chair"), () -> new OfficeChairBlock(color));
        }

        @Override
        protected Registrar<class_2248> autoInit() {
            return REGISTER;
        }
    };


    public static final RegistrySupplier<PaperBlock> PAPER = REGISTER.register(Devices.id("paper"), PaperBlock::new);


    public static Stream<class_2248> getAllBlocks() {
        return REGISTER.getIds().stream().map(REGISTER::get);
    }

    public static List<LaptopBlock> getAllLaptops() {
        return getAllBlocks().filter(block -> block instanceof LaptopBlock).map(block -> (LaptopBlock) block).toList();
    }

    public static List<PrinterBlock> getAllPrinters() {
        return getAllBlocks().filter(block -> block instanceof PrinterBlock).map(block -> (PrinterBlock) block).toList();
    }

    public static List<RouterBlock> getAllRouters() {
        return getAllBlocks().filter(block -> block instanceof RouterBlock).map(block -> (RouterBlock) block).toList();
    }

    public static List<OfficeChairBlock> getAllOfficeChairs() {
        return getAllBlocks().filter(block -> block instanceof OfficeChairBlock).map(block -> (OfficeChairBlock) block).toList();
    }
}
