package com.ultreon.devices.item;

import com.ultreon.devices.ModDeviceTypes;
import com.ultreon.devices.Devices;
import com.ultreon.devices.IDeviceType;
import com.ultreon.devices.Reference;
import com.ultreon.devices.util.Colored;
import dev.architectury.registry.registries.Registries;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.world.item.*;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Objects;

public class FlashDriveItem extends class_1792 implements Colored, SubItems, IDeviceType {

    private final class_1767 color;

    public FlashDriveItem(class_1767 color) {
        super(new class_1793().method_7892(Devices.TAB_DEVICE).method_7894(class_1814.field_8907).method_7889(1));
        this.color = color;
    }

    private static class_124 getFromColor(class_1767 color) {
        return switch (color) {
            case ORANGE, BROWN -> ChatFormatting.GOLD;
            case MAGENTA, PINK -> ChatFormatting.LIGHT_PURPLE;
            case LIGHT_BLUE -> ChatFormatting.BLUE;
            case YELLOW -> ChatFormatting.YELLOW;
            case LIME -> ChatFormatting.GREEN;
            case GRAY -> ChatFormatting.DARK_GRAY;
            case LIGHT_GRAY -> ChatFormatting.GRAY;
            case CYAN -> ChatFormatting.DARK_AQUA;
            case PURPLE -> ChatFormatting.DARK_PURPLE;
            case BLUE -> ChatFormatting.DARK_BLUE;
            case GREEN -> ChatFormatting.DARK_GREEN;
            case RED -> ChatFormatting.DARK_RED;
            case BLACK -> ChatFormatting.BLACK;
            default -> ChatFormatting.WHITE;
        };
    }

    @Override
    @SuppressWarnings("deprecation")
    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, @NotNull class_1836 isAdvanced) {
        String colorName = color.method_7792().replace("_", " ");
        colorName = WordUtils.capitalize(colorName);
        tooltip.add(class_2561.method_43470("Color: " + class_124.field_1067 + getFromColor(color).toString() + colorName));
    }

    @Override
    public class_2371<class_2960> getModels() {
        class_2371<class_2960> modelLocations = class_2371.method_10211();
        for (class_1767 color : class_1767.values())
            modelLocations.add(new class_2960(Reference.MOD_ID, Objects.requireNonNull(Registries.getId(this, class_2378.field_25108)).method_12832().substring(5) + "/" + color.method_7792()));
        return modelLocations;
    }

    @Override
    public class_1767 getColor() {
        return color;
    }

    @Override
    public ModDeviceTypes getDeviceType() {
        return ModDeviceTypes.FLASH_DRIVE;
    }
}
