package com.ultreon.devices.item;

import com.ultreon.devices.util.KeyboardHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

/**
 * @author MrCrayfish
 */
public class MotherboardItem extends ComponentItem {
    public MotherboardItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 level, @NotNull List<net.minecraft.class_2561> tooltip, @NotNull class_1836 isAdvanced) {
        class_2487 tag = stack.method_7969();
        if (!KeyboardHelper.isShiftDown()) {
            tooltip.add(net.minecraft.class_2561.method_43470("CPU: " + getComponentStatus(tag, "cpu")));
            tooltip.add(net.minecraft.class_2561.method_43470("RAM: " + getComponentStatus(tag, "ram")));
            tooltip.add(net.minecraft.class_2561.method_43470("GPU: " + getComponentStatus(tag, "gpu")));
            tooltip.add(net.minecraft.class_2561.method_43470("WIFI: " + getComponentStatus(tag, "wifi")));
            tooltip.add(net.minecraft.class_2561.method_43470(class_124.field_1054 + "Hold shift for help"));
        } else {
            tooltip.add(net.minecraft.class_2561.method_43470("To add the required components"));
            tooltip.add(net.minecraft.class_2561.method_43470("place the motherboard and the"));
            tooltip.add(net.minecraft.class_2561.method_43470("corresponding component into a"));
            tooltip.add(net.minecraft.class_2561.method_43470("crafting table to combine them."));
        }
    }

    private String getComponentStatus(class_2487 tag, String component) {
        if (tag != null && tag.method_10573("components", class_2520.field_33260)) {
            class_2487 components = tag.method_10562("components");
            if (components.method_10573(component, class_2520.field_33251)) {
                return class_124.field_1060 + "Added";
            }
        }
        return class_124.field_1061 + "Missing";
    }

    public static class Component extends ComponentItem {
        public Component(class_1793 properties) {
            super(properties);
        }
    }
}
