package com.ultreon.devices.network.task;

import com.ultreon.devices.Devices;
import com.ultreon.devices.api.app.Notification;
import com.ultreon.devices.network.Packet;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

/**
 * @author MrCrayfish
 */
public class NotificationPacket extends Packet<NotificationPacket> {
    private final class_2487 notificationTag;

    public NotificationPacket(class_2540 buf) {
        notificationTag = buf.method_10798();
    }

    public NotificationPacket(Notification notification) {
        this.notificationTag = notification.toTag();
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.method_10794(notificationTag);
    }

    @Override
    public boolean onMessage(Supplier<NetworkManager.PacketContext> ctx) {
        Devices.showNotification(notificationTag);
        return true;
    }
}
