package com.ultreon.devices.network.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.network.Packet;
import com.ultreon.devices.network.PacketHandler;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class RequestPacket extends Packet<RequestPacket> {
    private final int id;
    private final Task request;
    private class_2487 tag;

    public RequestPacket(class_2540 buf) {
        this.id = buf.readInt();
        String name = buf.method_19772();
        this.request = TaskManager.getTask(name);
        this.tag = buf.method_10798();
        //System.out.println("decoding");
    }

    public RequestPacket(int id, Task request) {
        this.id = id;
        this.request = request;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.writeInt(this.id);
        buf.method_10814(this.request.getName());
        class_2487 tag = new class_2487();
        this.request.prepareRequest(tag);
        buf.method_10794(tag);
    }

    @Override
    public boolean onMessage(Supplier<NetworkManager.PacketContext> ctx) {
        //System.out.println("RECEIVED from " + ctx.get().getPlayer().getUUID());
        request.processRequest(tag, Objects.requireNonNull(ctx.get().getPlayer()).field_6002, ctx.get().getPlayer());
        if (ctx.get().getPlayer() instanceof class_3222 player)
        PacketHandler.sendToClient(new ResponsePacket(id, request), player);
        return true;
    }

    public int getId() {
        return id;
    }

}
