package com.ultreon.devices.network.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.network.Packet;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class ResponsePacket extends Packet<ResponsePacket> {
    private final int id;
    private final Task request;
    private class_2487 tag;

    public ResponsePacket(class_2540 buf) {
        this.id = buf.readInt();
        boolean successful = buf.readBoolean();
        this.request = TaskManager.getTaskAndRemove(this.id);
        if (successful) this.request.setSuccessful();
        String name = buf.method_19772();
        this.tag = buf.method_10798();
    }

    public ResponsePacket(int id, Task request) {
        this.id = id;
        this.request = request;
    }

    @Override
    public void toBytes(class_2540 buf) {
        buf.writeInt(this.id);
        buf.writeBoolean(this.request.isSucessful());
        buf.method_10814(this.request.getName());
        class_2487 tag = new class_2487();
        this.request.prepareResponse(tag);
        buf.method_10794(tag);
        this.request.complete();
    }

    @Override
    public boolean onMessage(Supplier<NetworkManager.PacketContext> ctx) {
        request.processResponse(tag);
        request.callback(tag);
        return false;
    }
}
