package com.ultreon.devices.object;

import com.ultreon.devices.api.io.File;
import java.awt.*;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_2487;

public class Picture {
    public int[] pixels;
    public Size size;
    private File source;
    private final String name;
    private final String author;

    public Picture(String name, String author, Size size) {
        this.name = name;
        this.author = author;
        this.pixels = new int[size.width * size.height];
        this.size = size;
        init();
    }

    public static Picture fromFile(File file) {
        class_2487 data = file.getData();
        assert data != null;
        Picture picture = new Picture(data.method_10558("Name"), data.method_10558("Author"), Objects.requireNonNull(Size.getFromSize(data.method_10550("Resolution"))));
        picture.source = file;
        picture.pixels = data.method_10561("Pixels");
        return picture;
    }

    private void init() {
        Arrays.fill(pixels, new Color(1.0F, 1.0F, 1.0F, 0.0F).getRGB());
    }

    public File getSource() {
        return source;
    }

    public String getName() {
        return name;
    }

    public String getAuthor() {
        return author;
    }

    public int[] getPixels() {
        return pixels;
    }

    public int getWidth() {
        return size.width;
    }

    public int getHeight() {
        return size.height;
    }

    public int getPixelWidth() {
        return size.pixelWidth;
    }

    public int getPixelHeight() {
        return size.pixelHeight;
    }

    public int[] copyPixels() {
        int[] copiedPixels = new int[pixels.length];
        System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
        return copiedPixels;
    }

    @Override
    public String toString() {
        return name;
    }

    public void writeToNBT(class_2487 tagCompound) {
        tagCompound.method_10582("Name", getName());
        tagCompound.method_10582("Author", getAuthor());
        tagCompound.method_10539("Pixels", pixels);
        tagCompound.method_10569("Resolution", size.width);
    }

    public enum Size {
        X16(16, 16, 8, 8), X32(32, 32, 4, 4);

        public int width, height;
        public int pixelWidth, pixelHeight;

        Size(int width, int height, int pixelWidth, int pixelHeight) {
            this.width = width;
            this.height = height;
            this.pixelWidth = pixelWidth;
            this.pixelHeight = pixelHeight;
        }

        public static Size getFromSize(int size) {
            if (size == 16) return X16;
            if (size == 32) return X32;
            return null;
        }
    }
}
