package com.ultreon.devices.programs.auction;

import com.ultreon.devices.programs.auction.object.AuctionItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

public class AuctionManager {
    public static final AuctionManager INSTANCE = new AuctionManager();

    private final List<AuctionItem> items;

    private AuctionManager() {
        items = new ArrayList<AuctionItem>();
    }

    public void addItem(AuctionItem item) {
        if (!containsItem(item.getId())) {
            items.add(item);
        }
    }

    public boolean containsItem(UUID id) {
        for (AuctionItem item : items) {
            if (item.getId().equals(id)) {
                return true;
            }
        }
        return false;
    }

    public AuctionItem getItem(UUID uuid) {
        for (AuctionItem item : items) {
            if (item.getId().equals(uuid)) {
                return item;
            }
        }
        return null;
    }

    public void removeItem(UUID uuid) {
        for (AuctionItem item : items) {
            if (item.getId().equals(uuid)) {
                items.remove(item);
                return;
            }
        }
    }

    public List<AuctionItem> getItems() {
        return items;
    }

    public void tick() {
        for (AuctionItem item : items) {
            item.decrementTime();
        }
    }

    public void writeToNBT(class_2487 tag) {
        class_2499 tagList = new class_2499();
        items.stream().filter(i -> i.isValid()).forEach(i -> {
            class_2487 itemTag = new class_2487();
            i.writeToNBT(itemTag);
            tagList.add(itemTag);
        });
        tag.method_10566("auctionItems", tagList);
    }

    public void readFromNBT(class_2487 tag) {
        items.clear();

        class_2499 tagList = (class_2499) tag.method_10580("auctionItems");
        for (int i = 0; i < tagList.size(); i++) {
            class_2487 itemTag = tagList.method_10602(i);
            AuctionItem item = AuctionItem.readFromNBT(itemTag);
            items.add(item);
        }
    }

    public List<AuctionItem> getItemsForSeller(UUID seller) {
        return items.stream().filter(i -> i.getSellerId().equals(seller)).collect(Collectors.toList());
    }
}
