package com.ultreon.devices.programs.auction;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.app.Dialog;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.*;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.programs.auction.object.AuctionItem;
import com.ultreon.devices.programs.auction.task.TaskAddAuction;
import com.ultreon.devices.programs.auction.task.TaskBuyItem;
import com.ultreon.devices.programs.auction.task.TaskGetAuctions;
import com.ultreon.devices.programs.system.layout.StandardLayout;
import com.ultreon.devices.util.TimeUtil;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import java.awt.*;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;

@SuppressWarnings({"unused", "FieldCanBeLocal"})
public class MineBayApp extends Application {
    private static final class_2960 CHEST_GUI_TEXTURE = new class_2960("textures/gui/container/generic_54.png");
    private static final class_2960 MINEBAY_ASSETS = new class_2960("devices:textures/gui/minebay.png");

    private static final class_1799 EMERALD = new class_1799(class_1802.field_8687);

    private final String[] categories = {"Building", "Combat", "Tools", "Food", "Materials", "Redstone", "Alchemy", "Rare", "Misc"};

    private Layout layoutMyAuctions;
    private ItemList<AuctionItem> items;

    /* Add Item Layout */
    private Layout layoutSelectItem;
    private Inventory inventory;
    private Button buttonAddCancel;
    private Button buttonAddNext;

    /* Set Amount and Price Layout */
    private Layout layoutAmountAndPrice;
    private Label labelAmount;
    private NumberSelector selectorAmount;
    private Label labelPrice;
    private NumberSelector selectorPrice;
    private Button buttonAmountAndPriceBack;
    private Button buttonAmountAndPriceCancel;
    private Button buttonAmountAndPriceNext;

    /* Set Duration Layout */
    private Layout layoutDuration;
    private Label labelHours;
    private Label labelMinutes;
    private Label labelSeconds;
    private NumberSelector selectorHours;
    private NumberSelector selectorMinutes;
    private NumberSelector selectorSeconds;
    private Button buttonDurationBack;
    private Button buttonDurationCancel;
    private Button buttonDurationAdd;

    public MineBayApp() {
        //super(Reference.MOD_ID + "MineBay", "MineBay");
    }

    @Override
    public void onTick() {
        super.onTick();
        AuctionManager.INSTANCE.tick();
    }

    @Override
    public void init(@Nullable class_2487 intent) {
        var layoutMain = new StandardLayout(class_124.field_1067 + "Icons", 330, 153, this, null);
        setCurrentLayout(layoutMain);
        getCurrentLayout().setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294(pose, x, y, x + width, y + 25, Color.GRAY.getRGB());
            class_329.method_25294(pose, x, y + 24, x + width, y + 25, Color.DARK_GRAY.getRGB());
            class_329.method_25294(pose, x, y + 25, x + 95, y + height, Color.LIGHT_GRAY.getRGB());
            class_329.method_25294(pose, x + 94, y + 25, x + 95, y + height, Color.GRAY.getRGB());

            RenderSystem.setShaderTexture(0, MINEBAY_ASSETS);
            RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
            RenderUtil.drawRectWithTexture(pose, x + 5, y + 6, 0, 0, 61, 11, 61, 12);
        });

        Button btnAddItem = new Button(70, 5, "Add Item");
        btnAddItem.setSize(60, 15);
        btnAddItem.setClickListener((mouseX, mouseY, mouseButton) -> setCurrentLayout(layoutSelectItem));
        layoutMain.addComponent(btnAddItem);

        Button btnViewItem = new Button(135, 5, "Your Auctions");
        btnViewItem.setSize(80, 15);
        btnViewItem.setClickListener((mouseX, mouseY, mouseButton) -> {
            assert class_310.method_1551().field_1724 != null;
            TaskGetAuctions task = new TaskGetAuctions(class_310.method_1551().field_1724.method_5667());
            task.setCallback((nbt, success) -> {
                items.removeAll();
                for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                    items.addItem(item);
                }
            });
            TaskManager.sendTask(task);
        });
        layoutMain.addComponent(btnViewItem);

        Label labelBalance = new Label("Balance", 295, 3);
        labelBalance.setAlignment(Label.ALIGN_RIGHT);
        layoutMain.addComponent(labelBalance);

        final Label labelMoney = new Label("$0", 295, 13);
        labelMoney.setAlignment(Label.ALIGN_RIGHT);
        labelMoney.setScale(1);
        labelMoney.setShadow(false);
        layoutMain.addComponent(labelMoney);

        Label labelCategories = new Label("Categories", 5, 29);
        labelCategories.setShadow(false);
        layoutMain.addComponent(labelCategories);

        ItemList<String> categories = new ItemList<>(5, 40, 70, 7);
        for (String category : this.categories) {
            categories.addItem(category);
        }
        layoutMain.addComponent(categories);

        Label labelItems = new Label("Items", 100, 29);
        labelItems.setShadow(false);
        layoutMain.addComponent(labelItems);

        items = new ItemList<>(100, 40, 180, 4);
        items.setListItemRenderer(new ListItemRenderer<>(20) {
            @Override
            public void render(class_4587 pose, AuctionItem e, class_332 gui, class_310 mc, int x, int y, int width, int height, boolean selected) {
                if (selected) {
                    class_329.method_25294(pose, x, y, x + width, y + height, Color.DARK_GRAY.getRGB());
                } else {
                    class_329.method_25294(pose, x, y, x + width, y + height, Color.GRAY.getRGB());
                }

                RenderUtil.renderItem(x + 2, y + 2, e.getStack(), true);

                pose.method_22903();
                {
                    pose.method_22904(x + 24, y + 4, 0);
                    pose.method_22905(0.666f, 0.666f, 0);
                    mc.field_1772.method_30883(pose, e.getStack().method_7954(), 0, 0, Color.WHITE.getRGB());
                    mc.field_1772.method_1729(pose, TimeUtil.getTotalRealTime(e.getTimeLeft()), 0, 11, Color.LIGHT_GRAY.getRGB());
                }
                pose.method_22909();

                String price = "$" + e.getPrice();
                mc.field_1772.method_1729(pose, price, x - mc.field_1772.method_1727(price) + width - 5, y + 6, Color.YELLOW.getRGB());
            }
        });
        layoutMain.addComponent(items);

        Button btnBuy = new Button(100, 127, "Buy");
        btnBuy.setSize(50, 15);
        btnBuy.setClickListener((mouseX, mouseY, mouseButton) ->
        {
            final Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setPositiveText("Buy");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) -> {
                final int index = items.getSelectedIndex();
                if (index == -1) return;

                AuctionItem item = items.getItem(index);
                if (item != null) {
                    TaskBuyItem task = new TaskBuyItem(item.getId());
                    task.setCallback((nbt, success) ->
                    {
                        if (success) {
                            items.removeItem(index);
                        }
                    });
                    TaskManager.sendTask(task);
                }
            });
            dialog.setNegativeText("Cancel");
            dialog.setNegativeListener((mouseX1, mouseY1, mouseButton1) -> dialog.close());
            MineBayApp.this.openDialog(dialog);
        });
        layoutMain.addComponent(btnBuy);

        /* Select Item Layout */

        layoutSelectItem = new Layout(172, 87);
        layoutSelectItem.setTitle("Add Item");
        layoutSelectItem.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294(pose, x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
            class_329.method_25294(pose, x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Select an Item...", x + 5, y + 7, Color.WHITE.getRGB());
        });

        inventory = new Inventory(5, 28);
        inventory.setClickListener((mouseX, mouseY, mouseButton) ->
        {
            if (inventory.getSelectedSlotIndex() != -1) {
                assert class_310.method_1551().field_1724 != null;
                class_1799 stack = class_310.method_1551().field_1724.method_31548().method_5438(inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    buttonAddNext.setEnabled(true);
                    selectorAmount.setMax(stack.method_7947());
                    selectorAmount.setNumber(stack.method_7947());
                } else {
                    buttonAddNext.setEnabled(false);
                }
            }
        });
        layoutSelectItem.addComponent(inventory);

        buttonAddCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        buttonAddCancel.setToolTip("Cancel", "Go back to main page");
        buttonAddCancel.setClickListener((mouseX, mouseY, mouseButton) -> restoreDefaultLayout());
        layoutSelectItem.addComponent(buttonAddCancel);

        buttonAddNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        buttonAddNext.setToolTip("Next Page", "Set price and amount");
        buttonAddNext.setEnabled(false);
        buttonAddNext.setClickListener((mouseX, mouseY, mouseButton) ->
        {
            selectorAmount.updateButtons();
            selectorPrice.updateButtons();
            setCurrentLayout(layoutAmountAndPrice);
        });
        layoutSelectItem.addComponent(buttonAddNext);


        /* Set Amount and Price */

        layoutAmountAndPrice = new Layout(172, 87);
        layoutAmountAndPrice.setTitle("Add Item");
        layoutAmountAndPrice.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294(pose, x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
            class_329.method_25294(pose, x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Set amount and price...", x + 5, y + 7, Color.WHITE.getRGB());

            int offsetX = 14;
            int offsetY = 40;
            class_329.method_25294(pose, x + offsetX, y + offsetY, x + offsetX + 38, y + offsetY + 38, Color.BLACK.getRGB());
            class_329.method_25294(pose, x + offsetX + 1, y + offsetY + 1, x + offsetX + 37, y + offsetY + 37, Color.DARK_GRAY.getRGB());

            offsetX = 90;
            class_329.method_25294(pose, x + offsetX, y + offsetY, x + offsetX + 38, y + offsetY + 38, Color.BLACK.getRGB());
            class_329.method_25294(pose, x + offsetX + 1, y + offsetY + 1, x + offsetX + 37, y + offsetY + 37, Color.DARK_GRAY.getRGB());

            if (inventory.getSelectedSlotIndex() != -1) {
                assert mc.field_1724 != null;
                class_1799 stack = mc.field_1724.method_31548().method_5438(inventory.getSelectedSlotIndex());
                if (!stack.method_7960()) {
                    pose.method_22903();
                    {
                        pose.method_22904(x + 17, y + 43, 0);
                        pose.method_22905(2, 2, 0);
                        RenderUtil.renderItem(0, 0, stack, false);
                    }
                    pose.method_22909();
                }
            }

            pose.method_22903();
            {
                pose.method_22904(x + 92, y + 43, 0);
                pose.method_22905(2, 2, 0);
                RenderUtil.renderItem(0, 0, EMERALD, false);
            }
            pose.method_22909();
        });

        buttonAmountAndPriceBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        buttonAmountAndPriceBack.setClickListener((mouseX, mouseY, mouseButton) -> setCurrentLayout(layoutSelectItem));
        layoutAmountAndPrice.addComponent(buttonAmountAndPriceBack);

        buttonAmountAndPriceCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        buttonAmountAndPriceCancel.setClickListener((mouseX, mouseY, mouseButton) -> restoreDefaultLayout());
        layoutAmountAndPrice.addComponent(buttonAmountAndPriceCancel);

        buttonAmountAndPriceNext = new Button(154, 4, MINEBAY_ASSETS, 16, 12, 8, 8);
        buttonAmountAndPriceNext.setClickListener((mouseX, mouseY, mouseButton) -> setCurrentLayout(layoutDuration));
        layoutAmountAndPrice.addComponent(buttonAmountAndPriceNext);

        labelAmount = new Label("Amount", 16, 30);
        layoutAmountAndPrice.addComponent(labelAmount);

        selectorAmount = new NumberSelector(55, 42, 18);
        selectorAmount.setMax(64);
        layoutAmountAndPrice.addComponent(selectorAmount);

        labelPrice = new Label("Price", 96, 30);
        layoutAmountAndPrice.addComponent(labelPrice);

        selectorPrice = new NumberSelector(131, 42, 24);
        selectorPrice.setMax(999);
        layoutAmountAndPrice.addComponent(selectorPrice);


        /* Duration Layout */
        layoutDuration = new Layout(172, 87);
        layoutDuration.setTitle("Add Item");
        layoutDuration.setBackground((pose, gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            class_329.method_25294(pose, x, y, x + width, y + 22, Color.LIGHT_GRAY.getRGB());
            class_329.method_25294(pose, x, y + 22, x + width, y + 23, Color.DARK_GRAY.getRGB());
            mc.field_1772.method_1720(pose, "Set duration...", x + 5, y + 7, Color.WHITE.getRGB());
        });

        buttonDurationBack = new Button(122, 4, MINEBAY_ASSETS, 8, 12, 8, 8);
        buttonDurationBack.setClickListener((mouseX, mouseY, mouseButton) -> setCurrentLayout(layoutAmountAndPrice));
        layoutDuration.addComponent(buttonDurationBack);

        buttonDurationCancel = new Button(138, 4, MINEBAY_ASSETS, 0, 12, 8, 8);
        buttonDurationCancel.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(layoutMain));
        layoutDuration.addComponent(buttonDurationCancel);

        buttonDurationAdd = new Button(154, 4, MINEBAY_ASSETS, 24, 12, 8, 8);
        buttonDurationAdd.setClickListener((mouseX, mouseY, mouseButton) ->
        {
            final Dialog.Confirmation dialog = new Dialog.Confirmation();
            dialog.setMessageText("Are you sure you want to auction this item?");
            dialog.setPositiveText("Yes");
            dialog.setPositiveListener((mouseX1, mouseY1, mouseButton1) ->
            {
                int ticks = (int) TimeUtil.getRealTimeToTicks(selectorHours.getNumber(), selectorMinutes.getNumber(), selectorSeconds.getNumber());
                TaskAddAuction task = new TaskAddAuction(inventory.getSelectedSlotIndex(), selectorAmount.getNumber(), selectorPrice.getNumber(), ticks);
                task.setCallback((nbt, success) ->
                {
                    if (success) {
                        List<AuctionItem> auctionItems = AuctionManager.INSTANCE.getItems();
                        items.addItem(auctionItems.get(auctionItems.size() - 1));
                    }
                });
                TaskManager.sendTask(task);
                dialog.close();
                init(intent);
            });
            openDialog(dialog);
        });
        layoutDuration.addComponent(buttonDurationAdd);

        labelHours = new Label("Hrs", 45, 30);
        layoutDuration.addComponent(labelHours);

        labelMinutes = new Label("Mins", 76, 30);
        layoutDuration.addComponent(labelMinutes);

        labelSeconds = new Label("Secs", 105, 30);
        layoutDuration.addComponent(labelSeconds);

        DecimalFormat format = new DecimalFormat("00");

        selectorHours = new NumberSelector(45, 42, 20);
        selectorHours.setMax(23);
        selectorHours.setMin(0);
        selectorHours.setFormat(format);
        layoutDuration.addComponent(selectorHours);

        selectorMinutes = new NumberSelector(76, 42, 20);
        selectorMinutes.setMax(59);
        selectorMinutes.setMin(0);
        selectorMinutes.setFormat(format);
        layoutDuration.addComponent(selectorMinutes);

        selectorSeconds = new NumberSelector(107, 42, 20);
        selectorSeconds.setMax(59);
        selectorSeconds.setMin(1);
        selectorSeconds.setFormat(format);
        layoutDuration.addComponent(selectorSeconds);

        BankUtil.getBalance((nbt, success) ->
        {
            if (success) {
                labelMoney.setText("$" + Objects.requireNonNull(nbt, "Expected to get a tag from the get-balance task response.").method_10550("balance"));
            }
        });

        TaskGetAuctions task = new TaskGetAuctions();
        task.setCallback((nbt, success) ->
        {
            items.removeAll();
            for (AuctionItem item : AuctionManager.INSTANCE.getItems()) {
                items.addItem(item);
            }
        });
        TaskManager.sendTask(task);
    }

    @Override
    public void load(class_2487 tagCompound) {

    }

    @Override
    public void save(class_2487 tagCompound) {

    }
}
