package com.ultreon.devices.programs.auction.object;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class AuctionItem {
    private final UUID id;
    private final class_1799 stack;
    private final int price;
    private long timeLeft;
    private final UUID sellerId;

    public AuctionItem(class_1799 stack, int price, long timeLeft, UUID sellerId) {
        this.id = UUID.randomUUID();
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public AuctionItem(UUID id, class_1799 stack, int price, long timeLeft, UUID sellerId) {
        this.id = id;
        this.stack = stack;
        this.price = price;
        this.timeLeft = timeLeft;
        this.sellerId = sellerId;
    }

    public static AuctionItem readFromNBT(class_2487 tag) {
        UUID id = UUID.fromString(tag.method_10558("id"));
        class_2487 item = tag.method_10562("item");
        class_1799 stack = class_1799.method_7915(item);
        int price = tag.method_10550("price");
        long timeLeft = tag.method_10537("time");
        UUID sellerId = UUID.fromString(tag.method_10558("seller"));
        return new AuctionItem(id, stack, price, timeLeft, sellerId);
    }

    public UUID getId() {
        return id;
    }

    public class_1799 getStack() {
        return stack;
    }

    public int getPrice() {
        return price;
    }

    public UUID getSellerId() {
        return sellerId;
    }

    public boolean isValid() {
        return timeLeft > 0;
    }

    public void decrementTime() {
        if (timeLeft > 0) {
            timeLeft--;
        }
    }

    public long getTimeLeft() {
        return timeLeft;
    }

    public void setSold() {
        this.timeLeft = 0;
    }

    public void writeToNBT(class_2487 tag) {
        tag.method_10582("id", id.toString());
        class_2487 item = new class_2487();
        item = stack.method_7953(item);
        tag.method_10566("item", item);
        tag.method_10569("price", price);
        tag.method_10544("time", timeLeft);
        tag.method_10582("seller", sellerId.toString());
    }

    @Override
    public String toString() {
        return "{ " + id + ", " + stack + ", " + price + ", " + timeLeft + ", " + sellerId + " }";
    }
}
