package com.ultreon.devices.programs.auction.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.programs.auction.AuctionManager;
import com.ultreon.devices.programs.auction.object.AuctionItem;
import com.ultreon.devices.programs.system.object.Account;
import java.util.UUID;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class TaskBuyItem extends Task {
    private UUID id;

    public TaskBuyItem() {
        super("minebay_buy_item");
    }

    public TaskBuyItem(UUID id) {
        this();
        this.id = id;
    }

    @Override
    public void prepareRequest(class_2487 nbt) {
        nbt.method_10582("id", id.toString());
    }

    @Override
    public void processRequest(class_2487 nbt, class_1937 world, class_1657 player) {
        this.id = UUID.fromString(nbt.method_10558("id"));
        AuctionItem item = AuctionManager.INSTANCE.getItem(id);
        if (item != null && item.isValid()) {
            int price = item.getPrice();
            Account buyer = BankUtil.INSTANCE.getAccount(player);
            Account seller = BankUtil.INSTANCE.getAccount(item.getSellerId());
            if (buyer.pay(seller, price)) {
                item.setSold();
                world.method_8649(new class_1542(world, player.method_23317(), player.method_23318(), player.method_23321(), item.getStack().method_7972()));
                this.setSuccessful();
            }
        }
    }

    @Override
    public void prepareResponse(class_2487 nbt) {
    }

    @Override
    public void processResponse(class_2487 nbt) {
    }
}
