package com.ultreon.devices.programs.email.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.programs.email.EmailManager;
import com.ultreon.devices.programs.email.object.Email;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

public class TaskUpdateInbox extends Task {
    private List<Email> emails;

    public TaskUpdateInbox() {
        super("update_inbox");
    }

    @Override
    public void prepareRequest(class_2487 nbt) {
    }

    @Override
    public void processRequest(class_2487 nbt, class_1937 world, class_1657 player) {
        this.emails = EmailManager.INSTANCE.getEmailsForAccount(player);
    }

    @Override
    public void prepareResponse(class_2487 nbt) {
        class_2499 tagList = new class_2499();
        if (emails != null) {
            for (Email email : emails) {
                class_2487 emailTag = new class_2487();
                email.save(emailTag);
                tagList.add(emailTag);
            }
        }
        nbt.method_10566("emails", tagList);
    }

    @Override
    public void processResponse(class_2487 nbt) {
        EmailManager.INSTANCE.getInbox().clear();
        class_2499 emails = (class_2499) nbt.method_10580("emails");
        for (int i = 0; i < emails.size(); i++) {
            class_2487 emailTag = emails.method_10602(i);
            Email email = Email.readFromNBT(emailTag);
            EmailManager.INSTANCE.getInbox().add(email);
        }
    }
}
