package com.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Reference;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.util.GuiHelper;
import java.awt.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;

/**
 * @author MrCrayfish
 */
public abstract class ContainerBox extends Component {
    public static final int WIDTH = 128;
    protected static final class_2960 CONTAINER_BOXES_TEXTURE = new class_2960(Reference.MOD_ID, "textures/gui/container_boxes.png");
    protected List<Slot> slots = new ArrayList<>();
    protected int boxU, boxV;
    protected int height;
    protected class_1799 icon;
    protected String title;

    public ContainerBox(int left, int top, int boxU, int boxV, int height, class_1799 icon, String title) {
        super(left, top);
        this.boxU = boxU;
        this.boxV = boxV;
        this.height = height;
        this.icon = icon;
        this.title = title;
    }

    @Override
    protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        RenderSystem.setShaderTexture(0, CONTAINER_BOXES_TEXTURE);
        RenderUtil.drawRectWithTexture(pose, x, y + 12, boxU, boxV, WIDTH, height, WIDTH, height, 256, 256);
        //Gui.blit(pose, x, y + 12, WIDTH, height, boxU, boxV, 256, 256, WIDTH, height);

        int contentOffset = (WIDTH - (Laptop.getFont().method_1727(title) + 8 + 4)) / 2;
        pose.method_22903();
        {
            pose.method_22904(x + contentOffset, y, 0);
            pose.method_22905(0.5f, 0.5f, 0.5f);
            RenderUtil.renderItem(x+contentOffset-5, y-4, icon, false);
        }
        pose.method_22909();

        RenderUtil.drawStringClipped(pose, title, x + contentOffset + 8 + 4, y, 110, Color.WHITE.getRGB(), true);

        slots.forEach(slot -> slot.render(x, y + 12));
    }

    @Override
    protected void renderOverlay(class_4587 pose, Laptop laptop, class_310 mc, int mouseX, int mouseY, boolean windowActive) {
        slots.forEach(slot -> slot.renderOverlay(pose, laptop, xPosition, yPosition + 12, mouseX, mouseY));
    }

    protected static class Slot {
        private final int slotX;
        private final int slotY;
        private final class_1799 stack;

        public Slot(int slotX, int slotY, class_1799 stack) {
            this.slotX = slotX;
            this.slotY = slotY;
            this.stack = stack;
        }

        public void render(int x, int y) {
            RenderUtil.renderItem(x + slotX, y + slotY, stack, true);
        }

        public void renderOverlay(class_4587 pose, Laptop laptop, int x, int y, int mouseX, int mouseY) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + slotX, y + slotY, 16, 16)) {
                if (!stack.method_7960()) {
                    laptop.method_32634(pose, laptop.method_25408(stack), Optional.empty(), mouseX, mouseY/*, stack*/);
                }
            }

            // Todo: fix this.
//            GlStateManager.disableRescaleNormal();
//            RenderHelper.disableStandardItemLighting();
//            GlStateManager.disableDepth();
        }

        public class_1799 getStack() {
            return stack;
        }
    }
}
