package com.ultreon.devices.programs.gitweb.component.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.core.Laptop;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_4587;

/**
 * @author MrCrayfish
 */
public class FurnaceBox extends ContainerBox {
    public static final int HEIGHT = 68;

    private int progressTimer;
    private int fuelTimer;
    private final int fuelTime;

    public FurnaceBox(class_1799 input, class_1799 fuel, class_1799 result) {
        super(0, 0, 0, 68, HEIGHT, new class_1799(class_2246.field_10181), "Furnace");
        slots.add(new Slot(26, 8, input));
        slots.add(new Slot(26, 44, fuel));
        slots.add(new Slot(85, 26, result));
        this.fuelTime = getBurnTime(fuel, class_3956.field_17546);
    }

    @ExpectPlatform
    private static int getBurnTime(class_1799 stack, class_3956<?> type) {
        throw new AssertionError();
    }

    @Override
    protected void handleTick() {
        if (++progressTimer == 200) {
            progressTimer = 0;
        }
        if (--fuelTimer <= 0) {
            fuelTimer = fuelTime;
        }
    }

    @Override
    protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        super.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);

        RenderSystem.setShaderTexture(0, CONTAINER_BOXES_TEXTURE);

        int burnProgress = this.getBurnLeftScaled(13);
        this.method_25302(pose, x + 26, y + 52 - burnProgress, 128, 238 - burnProgress, 14, burnProgress + 1);

        int cookProgress = this.getCookProgressScaled(24);
        this.method_25302(pose, x + 49, y + 37, 128, 239, cookProgress + 1, 16);
    }

    private int getCookProgressScaled(int pixels) {
        return this.progressTimer * pixels / 200;
    }

    private int getBurnLeftScaled(int pixels) {
        int i = this.fuelTime;
        if (i == 0) {
            i = 200;
        }
        return this.fuelTimer * pixels / i + 1;
    }
}
