package com.ultreon.devices.programs.gitweb.module;

import com.mojang.datafixers.util.Pair;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.programs.gitweb.component.GitWebFrame;
import com.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import com.ultreon.devices.programs.gitweb.component.container.LoomBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1088;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_823;

import static com.ultreon.devices.programs.gitweb.module.ContainerModule.getItem;

public class BannerIIModule extends Module {
    @Override
    public String[] getRequiredData() {
        return new String[]{"banner"};
    }

    @Override
    public String[] getOptionalData() {
        return new String[]{"waving"};
    }

    @Override
    public int calculateHeight(Map<String, String> data, int width) {
        return com.ultreon.devices.programs.gitweb.module.BannerIIModule.LoomBox.HEIGHT;
    }

    @Override
    public void generate(GitWebFrame frame, Layout layout, int width, Map<String, String> data) {
        layout.addComponent(createContainer(data));
    }

    public com.ultreon.devices.programs.gitweb.module.BannerIIModule.LoomBox createContainer(Map<String, String> data) {
        return new com.ultreon.devices.programs.gitweb.module.BannerIIModule.LoomBox(getItem(data, "banner"), Boolean.parseBoolean(data.get("waving")));
    }

    public static class LoomBox extends Component {
        public static final int HEIGHT = 84;
        private final class_1799 banner;
        private final class_630 flag;
        private final List<Pair<class_6880<class_2582>, class_1767>> resultBannerPatterns;

        public LoomBox(class_1799 banner, boolean waving) {
            super(0, 0);
            this.banner = banner;
            this.flag = class_310.method_1551().method_31974().method_32072(class_5602.field_27678).method_32086("flag");

            if (!banner.method_7960())
                this.resultBannerPatterns = class_2573.method_24280(((class_1746)this.banner.method_7909()).method_7706(), class_2573.method_24281(this.banner));
            else
                this.resultBannerPatterns = new ArrayList<>();
        }

        @Override
        protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
            super.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);
            int i = x;//this.leftPos;
            int j = y;//this.topPos;
            if (banner.method_7960())return;
            class_308.method_24210();
            class_4597.class_4598 bufferSource = mc.method_22940().method_23000();
            pose.method_22903();
            //pose.translate((double)(i + 139), (double)(j + 52), 0.0D);
            pose.method_22904(i+139,j+90,0.0D);
            pose.method_22905(48.0F, -48.0F, 48.0F);
        //    pose.scale(24.0F, -24.0F, 1.0F);
            pose.method_22904(0.5D, 0.5D, 0.5D);
            float f = 0.6666667F;
            pose.method_22905(f, -f, -f);
            long l = System.currentTimeMillis()/50;
            System.out.println(l);
            float h = ((float)Math.floorMod(l, 100L) + partialTicks) / 100.0f;

            this.flag.field_3675 = (float) Math.toRadians(30);
            this.flag.field_3654 = (-0.0125f + 0.01f * class_3532.method_15362((float)Math.PI * 2 * h)) * (float)Math.PI;
           // this.flag.xRot = 0.0F;
            this.flag.field_3656 = -32.0F;
            class_823.method_29999(pose, bufferSource, 15728880, class_4608.field_21444, this.flag, class_1088.field_20847, true, this.resultBannerPatterns);
            pose.method_22909();
            bufferSource.method_22993();


        }
    }
}
// 128, 72