package com.ultreon.devices.programs.gitweb.module;

import com.ultreon.devices.programs.gitweb.component.container.BrewingBox;
import com.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;

/**
 * @author MrCrayfish
 */
public class BrewingModule extends ContainerModule {
    @Override
    public String[] getOptionalData() {
        List<String> optionalData = new ArrayList<>(Arrays.asList(super.getOptionalData()));
        optionalData.add("slot-fuel");
        optionalData.add("slot-input");
        for (int i = 0; i < 3; i++) {
            optionalData.add("slot-output-" + (i + 1));
        }
        return optionalData.toArray(new String[0]);
    }

    @Override
    public int getHeight() {
        return BrewingBox.HEIGHT;
    }

    @Override
    public ContainerBox createContainer(Map<String, String> data) {
        class_1799 fuel = getItem(data, "slot-fuel");
        class_1799 input = getItem(data, "slot-input");
        class_1799[] output = new class_1799[3];
        Arrays.fill(output, class_1799.field_8037);
        for (int i = 0; i < output.length; i++) {
            output[i] = getItem(data, "slot-output-" + (i + 1));
        }
        return new BrewingBox(fuel, input, output);
    }
}
