package com.ultreon.devices.programs.gitweb.module;

import com.ultreon.devices.programs.gitweb.component.container.ContainerBox;
import com.ultreon.devices.programs.gitweb.component.container.FurnaceBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;

/**
 * @author MrCrayfish
 */
public class FurnaceModule extends ContainerModule {
    @Override
    public String[] getOptionalData() {
        List<String> optionalData = new ArrayList<>();
        optionalData.addAll(Arrays.asList(super.getOptionalData()));
        optionalData.add("slot-input");
        optionalData.add("slot-fuel");
        optionalData.add("slot-result");
        return optionalData.toArray(new String[0]);
    }

    @Override
    public int getHeight() {
        return FurnaceBox.HEIGHT;
    }

    @Override
    public ContainerBox createContainer(Map<String, String> data) {
        class_1799 input = getItem(data, "slot-input");
        class_1799 fuel = getItem(data, "slot-fuel");
        class_1799 result = getItem(data, "slot-result");
        return new FurnaceBox(input, fuel, result);
    }
}
