package com.ultreon.devices.programs.system;

import com.jab125.version.VersionInterval;
import com.jab125.version.VersionPredicate;
import com.jab125.version.VersionPredicateParser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.api.app.*;
import com.ultreon.devices.api.app.component.Button;
import com.ultreon.devices.api.app.component.ItemList;
import com.ultreon.devices.api.app.component.Label;
import com.ultreon.devices.api.app.component.Text;
import com.ultreon.devices.api.app.renderer.ListItemRenderer;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.system.AppStore;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.component.AppGrid;
import com.ultreon.devices.util.Vulnerability;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

import java.awt.*;
import java.lang.System;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class VulnerabilityApp extends SystemApp {
    private long lastClick = 0;
    private static final Color ITEM_BACKGROUND = Color.decode("0x9E9E9E");
    private static final Color ITEM_SELECTED = Color.decode("0x757575");
    private Layout mainMenu;

    @Override
    public void init(@Nullable class_2487 intent) {
        this.setCurrentLayout(createMenu());
    }
    int marginX = 10;
    int marginY = 10;
    int paddingY = 4;
    private Layout createMenu() {
        this.mainMenu = new Layout(250, 105);

        ItemList<Vulnerability> itemListResults = new ItemList<>(5, 5, AppStore.LAYOUT_WIDTH - 10, 5, true);
        itemListResults.setItems(Devices.getVulnerabilities());
        itemListResults.sortBy(Comparator.comparing(vulnerability -> -vulnerability.effectiveSeverity()));
        itemListResults.setListItemRenderer(new ListItemRenderer<>(18) {
            @Override
            public void render(PoseStack pose, Vulnerability app, GuiComponent gui, Minecraft mc, int x, int y, int width, int height, boolean selected) {
                Gui.fill(pose, x, y, x + width, y + height, selected ? ITEM_SELECTED.getRGB() : ITEM_BACKGROUND.getRGB());

                RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
                var icon = getIconFor(app);
                pose.pushPose();
                pose.translate(x, y, 0);
                pose.translate(4.5f/1.5f/2, 4.5f/1.5f/2, 0);
                pose.scale(1.5f, 1.5f, 1);
                icon.draw(pose, mc, 0, 0);
                pose.popPose();
                RenderUtil.drawStringClipped(pose, app.title(), x + 20, y + 5, itemListResults.getWidth() - 22, Color.WHITE.getRGB(), false);
            }
        });
        itemListResults.setItemClickListener((info, index, mouseButton) -> {
            if (mouseButton == 0) {
                if (System.currentTimeMillis() - this.lastClick <= 200) {
                    setCurrentLayout(createMenuFromVulnerability(info));
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            }
        });
        mainMenu.addComponent(itemListResults);


        return mainMenu;
    }

    private IIcon getIconFor(Vulnerability app) {
        if (!app.affectsCurrentVersion()) return Icons.WARNING_GRAY;
        var severity = app.severity();
        if (severity < 3) {
            return Icons.WARNING;
        }
        if (severity < 6) {
            return Icons.FLASHED_WARNING;
        }
        if (severity <= 10) {
            return Icons.ERROR;
        }
        return Icons.WARNING;
    }

    private Layout createMenuFromVulnerability(Vulnerability vulnerability) {
        var layout = new Layout(250, 105);
        var behindTheNews = new Button(5, 5, Icons.ARROW_LEFT);
        behindTheNews.setClickListener((__, ___, ____) -> {
            setCurrentLayout(mainMenu);
        });
        layout.addComponent(behindTheNews);
        layout.addComponent(class_156.method_654(new Label(vulnerability.title(), 5, 5 + behindTheNews.getHeight()+2), t -> t.setScale(1.25)));
        layout.addComponent(new Label(vulnerability.reporter() == null ? "Unknown" : vulnerability.reporter(), 5, 18 + behindTheNews.getHeight()+2));
        layout.addComponent(new Label("Affected Versions: " + re(vulnerability.affectedVersions()), 5, 28 + behindTheNews.getHeight()+2));
        layout.addComponent(new Label("Fixed in: " + re(vulnerability.fixVersion(), true), 5, 38 + behindTheNews.getHeight()+2));
        var d = ScrollableLayout.create(5, 48 + behindTheNews.getHeight()+2, layout.width-5, 58 - (behindTheNews.getHeight()+2), vulnerability.description() == null ? "No description provided" : vulnerability.description(), false);
        layout.addComponent(d);
        return layout;
    }

    private String re(Collection<VersionPredicate> d, boolean e) {
        if (e && d.isEmpty()) return "!(-∞,∞)";
       // VersionInterval prev = VersionInterval;
        ArrayList<String> l = new ArrayList<>();
        for (VersionPredicate versionPredicate : d) {
            if (versionPredicate instanceof VersionPredicateParser.SingleVersionPredicate p && p.getInterval().getMin().equals(p.getInterval().getMax())) {
                l.add(p.getRefVersion().getFriendlyString());
            } else
            l.add(versionPredicate.getInterval().toString());
        }
       // var dd = prev.or(l);
//        for (VersionPredicate versionPredicate : d) {
//            System.out.println(versionPredicate);
//            System.out.println(versionPredicate.getInterval());
//            prev = prev.or(versionPredicate.getInterval());
//        }
        StringBuilder a = new StringBuilder();
        for (String versionInterval : l) {
            a.append(versionInterval).append(" ");
        }
        a.deleteCharAt(a.length()-1);
        return a.toString();
    }

    private String re(Collection<VersionPredicate> d) {
        return re(d, false);
    }

    @Override
    public void load(class_2487 tag) {

    }

    @Override
    public void save(class_2487 tag) {

    }
}
