package com.ultreon.devices.programs.system.component;

import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.Icons;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Image;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.programs.system.object.ImageEntry;
import com.ultreon.devices.util.GuiHelper;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;


/**
 * @author MrCrayfish
 */
@SuppressWarnings("unused")
public class SlideShow extends Component {
    private static final java.awt.Color OVERLAY = new java.awt.Color(0f, 0f, 0f, 0.15f);
    private static final java.awt.Color OVERLAY_HOVER = new java.awt.Color(0.35f, 0.35f, 0.35f, 0.15f);

    private final int width;
    private final int height;

    private final class_2371<ImageEntry> IMAGES = class_2371.method_10211();
    private final Image image;
    private int currentImage = -1;

    /**
     * The default constructor for a component.
     * <p>
     * Laying out components is simply relative positioning. So for left (x position),
     * specific how many pixels from the left of the application window you want
     * it to be positioned at. The top is the same, but instead from the top (y position).
     *
     * @param left how many pixels from the left
     * @param top  how many pixels from the top
     */
    public SlideShow(int left, int top, int width, int height) {
        super(left, top);
        this.width = width;
        this.height = height;
        this.image = new Image(left, top, width, height);
        this.image.setBorderVisible(true);
    }

    @Override
    protected void init(Layout layout) {
        image.setDrawFull(true);
        image.init(layout);
    }

    @Override
    protected void handleLoad() {
        image.handleLoad();
    }

    @Override
    protected void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (!this.visible) return;
        image.render(pose, laptop, mc, x, y, mouseX, mouseY, windowActive, partialTicks);

        if (currentImage > 0) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x, y, 15, height)) {
                class_329.method_25294(pose, x, y, x + 15, y + height, OVERLAY_HOVER.getRGB());
            } else {
                class_329.method_25294(pose, x, y, x + 15, y + height, OVERLAY.getRGB());
            }
            Icons.CHEVRON_LEFT.draw(pose, mc, x + 2, y + (height - 10) / 2);
        }

        if (currentImage < IMAGES.size() - 1) {
            if (GuiHelper.isMouseWithin(mouseX, mouseY, x + width - 15, y, 15, height)) {
                class_329.method_25294(pose, x + width - 15, y, x + width, y + height, OVERLAY_HOVER.getRGB());
            } else {
                class_329.method_25294(pose, x + width - 15, y, x + width, y + height, OVERLAY.getRGB());
            }
            Icons.CHEVRON_RIGHT.draw(pose, mc, x + 3 + width - 15, y + (height - 10) / 2);
        }
    }

    @Override
    protected void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled || mouseButton != 0) return;

        if (GuiHelper.isMouseWithin(mouseX, mouseY, xPosition, yPosition, 15, height)) {
            if (currentImage > 0) {
                this.setImage(currentImage - 1);
            }
        }

        if (GuiHelper.isMouseWithin(mouseX, mouseY, xPosition + width - 15, yPosition, 15, height)) {
            if (currentImage < IMAGES.size() - 1) {
                this.setImage(currentImage + 1);
            }
        }
    }

    public void addImage(class_2960 resource) {
        IMAGES.add(new ImageEntry(resource));
        if (currentImage == -1) {
            this.setImage(0);
        }
    }

    public void addImage(String url) {
        IMAGES.add(new ImageEntry(url));
        if (currentImage == -1) {
            this.setImage(0);
        }
    }

    @SuppressWarnings("ConstantConditions")
    public void setImage(int index) {
        if (IMAGES.isEmpty() && index < 0 && index >= IMAGES.size()) return;

        currentImage = index;

        ImageEntry entry = IMAGES.get(index);
        switch (entry.getType()) {
            case LOCAL -> image.setImage(entry.getResource());
            case REMOTE -> image.setImage(entry.getUrl());
        }
    }
}
