package com.ultreon.devices.programs.system.object;

import java.awt.*;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

/**
 * @author MrCrayfish
 */
public class ColorScheme {
    public int textColor;
    public int textSecondaryColor;
    public int headerColor;
    public int backgroundColor;
    public int backgroundSecondaryColor;
    public int itemBackgroundColor;
    public int itemHighlightColor;

    public ColorScheme() {
        resetDefault();
    }

    public static ColorScheme fromTag(class_2487 tag) {
        ColorScheme scheme = new ColorScheme();
        if (tag.method_10573("textColor", class_2520.field_33253)) {
            scheme.textColor = tag.method_10550("textColor");
        }
        if (tag.method_10573("textSecondaryColor", class_2520.field_33253)) {
            scheme.textSecondaryColor = tag.method_10550("textSecondaryColor");
        }
        if (tag.method_10573("headerColor", class_2520.field_33253)) {
            scheme.headerColor = tag.method_10550("headerColor");
        }
        if (tag.method_10573("backgroundColor", class_2520.field_33253)) {
            scheme.backgroundColor = tag.method_10550("backgroundColor");
        }
        if (tag.method_10573("backgroundSecondaryColor", class_2520.field_33253)) {
            scheme.backgroundSecondaryColor = tag.method_10550("backgroundSecondaryColor");
        }
        if (tag.method_10573("itemBackgroundColor", class_2520.field_33253)) {
            scheme.itemBackgroundColor = tag.method_10550("itemBackgroundColor");
        }
        if (tag.method_10573("itemHighlightColor", class_2520.field_33253)) {
            scheme.itemHighlightColor = tag.method_10550("itemHighlightColor");
        }
        return scheme;
    }

    public int getTextColor() {
        return textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextSecondaryColor() {
        return textSecondaryColor;
    }

    public void setTextSecondaryColor(int textSecondaryColor) {
        this.textSecondaryColor = textSecondaryColor;
    }

    public int getHeaderColor() {
        return headerColor;
    }

    public void setHeaderColor(int headerColor) {
        this.headerColor = headerColor;
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getBackgroundSecondaryColor() {
        return backgroundSecondaryColor;
    }

    public void setBackgroundSecondaryColor(int backgroundSecondaryColor) {
        this.backgroundSecondaryColor = backgroundSecondaryColor;
    }

    public int getItemBackgroundColor() {
        return itemBackgroundColor;
    }

    public void setItemBackgroundColor(int itemBackgroundColor) {
        this.itemBackgroundColor = itemBackgroundColor;
    }

    public int getItemHighlightColor() {
        return itemHighlightColor;
    }

    public void setItemHighlightColor(int itemHighlightColor) {
        this.itemHighlightColor = itemHighlightColor;
    }

    public void resetDefault() {
        textColor = Color.decode("0xFFFFFF").getRGB();
        textSecondaryColor = Color.decode("0xABEFF4").getRGB();
        headerColor = Color.decode("0x387A96").getRGB();
        //backgroundColor = Color.decode("0x535861").getRGB();
        backgroundColor = Color.decode("0x6899C2").getRGB();
        backgroundSecondaryColor = Color.decode("0x36C052").getRGB();
        itemBackgroundColor = Color.decode("0x2E6897").getRGB();
        itemHighlightColor = Color.decode("0x8B74C9").getRGB();
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("textColor", textColor);
        tag.method_10569("textSecondaryColor", textSecondaryColor);
        tag.method_10569("headerColor", headerColor);
        tag.method_10569("backgroundColor", backgroundColor);
        tag.method_10569("backgroundSecondaryColor", backgroundSecondaryColor);
        tag.method_10569("itemBackgroundColor", itemBackgroundColor);
        tag.method_10569("itemHighlightColor", itemHighlightColor);
        return tag;
    }
}
