package com.ultreon.devices.programs.system.task;

import com.ultreon.devices.api.task.Task;
import com.ultreon.devices.api.utils.BankUtil;
import com.ultreon.devices.programs.system.object.Account;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class TaskAdd extends Task {
    private int amount;

    public TaskAdd() {
        super("bank_add");
    }

    public TaskAdd(int amount) {
        this();
        this.amount = amount;
    }

    @Override
    public void prepareRequest(class_2487 tag) {
        tag.method_10569("amount", this.amount);
    }

    @Override
    public void processRequest(class_2487 tag, class_1937 level, class_1657 player) {
        int amount = tag.method_10550("amount");
        Account sender = BankUtil.INSTANCE.getAccount(player);
        sender.add(amount);
        this.setSuccessful();
    }

    @Override
    public void prepareResponse(class_2487 tag) {
        tag.method_10569("balance", this.amount);
    }

    @Override
    public void processResponse(class_2487 tag) {
    }
}
