package com.ultreon.devices.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ultreon.devices.init.DeviceItems;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import net.minecraft.class_1767;

public abstract class DyeableRegistration<T> implements Iterable<RegistrySupplier<T>> {
    private final HashMap<class_1767, RegistrySupplier<T>> map = new HashMap<>();
    private final List<RegistrySupplier<T>> l = new ArrayList<>();
    public DyeableRegistration() {
        var registrar = this.autoInit();
        if (registrar != null) {
            register(registrar, this);
        }
    }
    public static <T> void register(Registrar<T> registrar, DyeableRegistration<T> dyeableRegistration) {
        for (class_1767 dye : getDyes()) {
            System.out.println("registering for " + dye);
            var dg = dyeableRegistration.register(registrar, dye);
            dyeableRegistration.l.add(dg);
            dyeableRegistration.map.put(dye, dg);
        }
    }

    private static ImmutableList<class_1767> getDyes() {
        return ImmutableList.of(
                class_1767.field_7952,
                class_1767.field_7967,
                class_1767.field_7944,
                class_1767.field_7963,
                class_1767.field_7957,
                class_1767.field_7964,
                class_1767.field_7946,
                class_1767.field_7947,
                class_1767.field_7961,
                class_1767.field_7942,
                class_1767.field_7955,
                class_1767.field_7951,
                class_1767.field_7966,
                class_1767.field_7945,
                class_1767.field_7958,
                class_1767.field_7954
        );
    }
    public abstract RegistrySupplier<T> register(Registrar<T> registrar, class_1767 color);

    public ImmutableMap<class_1767, RegistrySupplier<T>> getMap() {
        return ImmutableMap.copyOf(map);
    }

    protected Registrar<T> autoInit() {
        return null;
    }

    public RegistrySupplier<T> of(class_1767 dyeColor) {
        return map.get(dyeColor);
    }

    @NotNull
    @Override
    public Iterator<RegistrySupplier<T>> iterator() {
        return l.iterator();
    }
}
