/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.classloader.impl;

import com.jab125.classloader.impl.ClassScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class CustomClassLoader {
    private final ArrayList<String> executionClasses = new ArrayList();
    public ByteClassLoader cl;

    public void load(JarFile jar) throws IOException {
        this.getF(jar);
    }

    private void getF(JarFile jar) throws IOException {
        HashMap<String, byte[]> hm = new HashMap<String, byte[]>();
        for (JarEntry jarEntry : jar.stream().toList()) {
            if (jarEntry.isDirectory() || !jarEntry.getRealName().endsWith(".class")) continue;
            InputStream d = jar.getInputStream(jarEntry);
            byte[] bytes = d.readAllBytes();
            int asmVer = 589824;
            ClassReader classReader = new ClassReader(bytes);
            ClassWriter classWriter = new ClassWriter(classReader, 3);
            ClassScanner cs = new ClassScanner(asmVer, (ClassVisitor)classWriter);
            classReader.accept((ClassVisitor)cs, 8);
            ClassNode cn = new ClassNode(asmVer);
            classReader.accept((ClassVisitor)cn, 3);
            hm.put(classReader.getClassName().replaceAll("/", "."), classWriter.toByteArray());
            if (!cs.isH()) continue;
            this.executionClasses.add(classReader.getClassName().replaceAll("/", "."));
        }
        this.cl = new ByteClassLoader(this.getClass().getClassLoader(), hm);
    }

    public class ByteClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs;

        public ByteClassLoader(ClassLoader parent, Map<String, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            this.extraClassDefs = new HashMap<String, byte[]>(extraClassDefs);
        }

        public ArrayList<String> getExecutionClasses() {
            return CustomClassLoader.this.executionClasses;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }
}

