/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices;

import com.ultreon.devices.Devices;
import com.ultreon.devices.api.ApplicationManager;
import com.ultreon.devices.block.LaptopBlock;
import com.ultreon.devices.block.PrinterBlock;
import com.ultreon.devices.block.RouterBlock;
import com.ultreon.devices.block.entity.renderer.LaptopRenderer;
import com.ultreon.devices.block.entity.renderer.OfficeChairRenderer;
import com.ultreon.devices.block.entity.renderer.PaperRenderer;
import com.ultreon.devices.block.entity.renderer.PrinterRenderer;
import com.ultreon.devices.block.entity.renderer.RouterRenderer;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.fabric.ClientModEventsImpl;
import com.ultreon.devices.init.DeviceBlockEntities;
import com.ultreon.devices.object.AppInfo;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.Registries;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClientModEvents {
    private static final Marker SETUP = MarkerFactory.getMarker((String)"SETUP");
    private static final Logger LOGGER = Devices.LOGGER;

    public static void clientSetup() {
        LOGGER.info("Doing some client setup.");
        LOGGER.info(SETUP, "Adding default wallpapers.");
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_1.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_2.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_3.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_4.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_5.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_6.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_7.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_8.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_9.png"));
        Laptop.addWallpaper(new class_2960("devices:textures/gui/laptop_wallpaper_10.png"));
        ClientModEvents.registerRenderLayers();
        ClientModEvents.registerRenderers();
        ClientModEvents.registerLayerDefinitions();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ReloaderListener());
    }

    private static void registerRenderLayers() {
    }

    public static void generateIconAtlas() {
        int ICON_SIZE = 14;
        var imageWriter = new Object(){
            final BufferedImage atlas = new BufferedImage(224, 224, 2);
            final Graphics g = this.atlas.createGraphics();
            int index = 0;
            int mode = 0;

            public boolean writeImage(AppInfo info, class_2960 location) {
                try {
                    System.out.println(location);
                    class_3298 resource = class_310.method_1551().method_1478().method_14486(location).orElse(null);
                    InputStream input = resource.method_14482();
                    if (input != null) {
                        BufferedImage icon = ImageIO.read(input);
                        if (icon.getWidth() != 14 || icon.getHeight() != 14) {
                            Devices.LOGGER.error("Incorrect icon size for " + (info == null ? null : info.getId()) + " (Must be 14 by 14 pixels)");
                            return false;
                        }
                        int iconU = this.index % 16 * 14;
                        int iconV = this.index / 16 * 14;
                        this.g.drawImage(icon, iconU, iconV, 14, 14, null);
                        if (info != null) {
                            AppInfo.Icon.Glyph glyph = switch (this.mode) {
                                case 0 -> info.getIcon().getBase();
                                case 1 -> info.getIcon().getOverlay0();
                                case 2 -> info.getIcon().getOverlay1();
                                default -> throw new IllegalStateException("Unexpected value: " + this.mode);
                            };
                            System.out.println("set glyph" + this.mode + "to " + iconU + ", " + iconV);
                            glyph.setU(iconU);
                            glyph.setV(iconV);
                        }
                        ++this.index;
                    } else {
                        Devices.LOGGER.error("Icon for application '" + (info == null ? null : info.getId()) + "' could not be found at '" + resource.method_14480() + "'");
                    }
                }
                catch (Exception e) {
                    Devices.LOGGER.error("Unable to load icon for " + (info == null ? null : info.getId()));
                }
                return false;
            }

            public void finish() {
                this.g.dispose();
                try {
                    ImageIO.write((RenderedImage)this.atlas, "png", Paths.get("it.png", new String[0]).toFile());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)this.atlas, "png", output);
                    byte[] bytes = output.toByteArray();
                    ByteArrayInputStream input = new ByteArrayInputStream(bytes);
                    class_310.method_1551().method_20493(() -> {
                        try {
                            class_310.method_1551().method_1531().method_4616(Laptop.ICON_TEXTURES, (class_1044)new class_1043(class_1011.method_4309((InputStream)input)));
                            System.out.println("registering texture");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        imageWriter.writeImage(null, new class_2960("devices", "textures/app/icon/base/missing.png"));
        for (AppInfo info : ApplicationManager.getAllApplications()) {
            if (info.getIcon() == null) continue;
            imageWriter.mode = 0;
            imageWriter.writeImage(info, info.getIcon().getBase().getResourceLocation());
            imageWriter.mode = 1;
            imageWriter.writeImage(info, info.getIcon().getOverlay0().getResourceLocation());
            imageWriter.mode = 2;
            imageWriter.writeImage(info, info.getIcon().getOverlay1().getResourceLocation());
        }
        imageWriter.mode = 0;
        imageWriter.finish();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setRenderLayer(class_2248 block, class_1921 type) {
        void var1_1;
        ClientModEventsImpl.setRenderLayer(block, (class_1921)var1_1);
    }

    public static void registerRenderers() {
        LOGGER.info("Registering renderers.");
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DeviceBlockEntities.LAPTOP.get()), LaptopRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DeviceBlockEntities.PRINTER.get()), PrinterRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DeviceBlockEntities.PAPER.get()), PaperRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DeviceBlockEntities.ROUTER.get()), RouterRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)DeviceBlockEntities.SEAT.get()), OfficeChairRenderer::new);
    }

    public static void registerLayerDefinitions() {
        LOGGER.info("Registering layer definitions.");
    }

    private static /* synthetic */ void lambda$registerRenderLayers$2(RouterBlock block) {
        LOGGER.debug(SETUP, "Setting render layer for router {}", (Object)Registries.getId((Object)block, (class_5321)class_2378.field_25105));
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{block});
    }

    private static /* synthetic */ void lambda$registerRenderLayers$1(PrinterBlock block) {
        LOGGER.debug(SETUP, "Setting render layer for printer {}", (Object)Registries.getId((Object)block, (class_5321)class_2378.field_25105));
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{block});
    }

    private static /* synthetic */ void lambda$registerRenderLayers$0(LaptopBlock block) {
        LOGGER.debug(SETUP, "Setting render layer for laptop {}", (Object)Registries.getId((Object)block, (class_5321)class_2378.field_25105));
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{block});
    }

    public static class ReloaderListener
    implements class_3302 {
        @NotNull
        public CompletableFuture<Void> method_25931(@NotNull class_3302.class_4045 preparationBarrier, @NotNull class_3300 resourceManager, @NotNull class_3695 preparationsProfiler, @NotNull class_3695 reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
            LOGGER.debug("Reloading resources from the Device Mod.");
            return CompletableFuture.runAsync(() -> {
                if (ApplicationManager.getAllApplications().size() > 0) {
                    ApplicationManager.getAllApplications().forEach(AppInfo::reload);
                    ClientModEvents.generateIconAtlas();
                }
            }, gameExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
        }
    }
}

