/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices;

import com.ultreon.devices.fabric.DeviceConfigImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import net.minecraft.class_2487;
import net.minecraftforge.common.ForgeConfigSpec;

public class DeviceConfig {
    private static final String CATEGORY_LAPTOP = "laptopSettings";
    public static final ForgeConfigSpec.IntValue PING_RATE;
    private static final String CATEGORY_ROUTER = "routerSettings";
    public static final ForgeConfigSpec.IntValue SIGNAL_RANGE;
    public static final ForgeConfigSpec.IntValue BEACON_INTERVAL;
    public static final ForgeConfigSpec.IntValue MAX_DEVICES;
    private static final String CATEGORY_PRINTING = "printerSettings";
    public static final ForgeConfigSpec.BooleanValue OVERRIDE_PRINT_SPEED;
    public static final ForgeConfigSpec.IntValue CUSTOM_PRINT_SPEED;
    public static final ForgeConfigSpec.IntValue MAX_PAPER_COUNT;
    private static final String CATEGORY_PIXEL_PAINTER = "pixelPainter";
    public static final ForgeConfigSpec.BooleanValue PIXEL_PAINTER_ENABLE;
    public static final ForgeConfigSpec.BooleanValue RENDER_PRINTED_3D;
    public static final String CATEGORY_DEBUG = "debug";
    public static final ForgeConfigSpec.BooleanValue DEBUG_BUTTON;
    public static final ForgeConfigSpec CONFIG;

    public static void readSyncTag(class_2487 tag) {
        if (tag.method_10573("pingRate", 3)) {
            PING_RATE.set((Object)tag.method_10550("pingRate"));
        }
        if (tag.method_10573("signalRange", 3)) {
            SIGNAL_RANGE.set((Object)tag.method_10550("signalRange"));
        }
    }

    public static class_2487 writeSyncTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("pingRate", ((Integer)PING_RATE.get()).intValue());
        tag.method_10569("signalRange", ((Integer)SIGNAL_RANGE.get()).intValue());
        return tag;
    }

    public static void init() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register(Object context) {
        DeviceConfigImpl.register(context);
    }

    public static void restore() {
    }

    public void save() {
        CONFIG.save();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        PING_RATE = builder.comment("The amount of ticks the laptop waits until sending another ping to it's connected router.").defineInRange("laptopSettings.pingRate", 20, 1, 200);
        SIGNAL_RANGE = builder.comment("The range that routers can produce a signal to devices. This is the radius in blocks. Be careful when increasing this value, the performance is O(n^3) and larger numbers will have a bigger impact on the server").defineInRange("routerSettings.signalRange", 20, 10, 100);
        BEACON_INTERVAL = builder.comment("The amount of ticks the router waits before sending out a beacon signal. Higher number will increase performance but devices won't know as quick if they lost connection.").defineInRange("routerSettings.beaconInterval", 20, 1, 200);
        MAX_DEVICES = builder.comment("The maximum amount of devices that can be connected to the router.").defineInRange("routerSettings.maxDevices", 16, 1, 64);
        OVERRIDE_PRINT_SPEED = builder.comment("If enable, overrides all printing times with customPrintSpeed property").define("printerSettings.overridePrintSpeed", false);
        CUSTOM_PRINT_SPEED = builder.comment("The amount of seconds it takes to print a page. This is overridden if overridePrintSpeed is enabled.").defineInRange("printerSettings.customPrintSpeed", 20, 1, 600);
        MAX_PAPER_COUNT = builder.comment("The maximum amount of paper that can be used in the printer.").defineInRange("printerSettings.maxPaperCount", 64, 0, 99);
        PIXEL_PAINTER_ENABLE = builder.comment("Enable or disable the Pixel Painter app.").define("pixelPainter.enabled", true);
        RENDER_PRINTED_3D = builder.comment("Should the pixels on printed pictures be render in 3D? Warning, this will decrease the performance of the game. You shouldn't enable it if you have a slow computer.").define("pixelPainter.renderPrintedIn3d", false);
        DEBUG_BUTTON = builder.comment("Display a button to access a worldless laptop").define("debug.debugButton", Platform.isDevelopmentEnvironment());
        CONFIG = builder.build();
    }
}

