/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices;

import architectury_inject_devicesmod_common_c6ba0e21cdf94a45b61c323be63e2bc3_1b43ae5f017d8efed3a96c38fb9329fabf4d1a238d6d698c5183f600efe2706ddevices055devjar.PlatformMethods;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ultreon.devices.ClientModEvents;
import com.ultreon.devices.DeviceConfig;
import com.ultreon.devices.Reference;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.api.print.IPrint;
import com.ultreon.devices.api.print.PrintingManager;
import com.ultreon.devices.api.task.TaskManager;
import com.ultreon.devices.api.utils.OnlineRequest;
import com.ultreon.devices.block.PrinterBlock;
import com.ultreon.devices.core.client.ClientNotification;
import com.ultreon.devices.core.client.debug.ClientAppDebug;
import com.ultreon.devices.core.io.task.TaskGetFiles;
import com.ultreon.devices.core.io.task.TaskGetMainDrive;
import com.ultreon.devices.core.io.task.TaskGetStructure;
import com.ultreon.devices.core.io.task.TaskSendAction;
import com.ultreon.devices.core.io.task.TaskSetupFileBrowser;
import com.ultreon.devices.core.network.task.TaskConnect;
import com.ultreon.devices.core.network.task.TaskGetDevices;
import com.ultreon.devices.core.network.task.TaskPing;
import com.ultreon.devices.core.print.task.TaskPrint;
import com.ultreon.devices.core.task.TaskInstallApp;
import com.ultreon.devices.fabric.DevicesImpl;
import com.ultreon.devices.init.DeviceItems;
import com.ultreon.devices.network.PacketHandler;
import com.ultreon.devices.network.task.SyncApplicationPacket;
import com.ultreon.devices.network.task.SyncConfigPacket;
import com.ultreon.devices.object.AppInfo;
import com.ultreon.devices.programs.IconsApp;
import com.ultreon.devices.programs.PixelPainterApp;
import com.ultreon.devices.programs.TestApp;
import com.ultreon.devices.programs.auction.task.TaskAddAuction;
import com.ultreon.devices.programs.auction.task.TaskBuyItem;
import com.ultreon.devices.programs.auction.task.TaskGetAuctions;
import com.ultreon.devices.programs.debug.TextAreaApp;
import com.ultreon.devices.programs.email.task.TaskCheckEmailAccount;
import com.ultreon.devices.programs.email.task.TaskDeleteEmail;
import com.ultreon.devices.programs.email.task.TaskRegisterEmailAccount;
import com.ultreon.devices.programs.email.task.TaskSendEmail;
import com.ultreon.devices.programs.email.task.TaskUpdateInbox;
import com.ultreon.devices.programs.email.task.TaskViewEmail;
import com.ultreon.devices.programs.example.ExampleApp;
import com.ultreon.devices.programs.system.SystemApp;
import com.ultreon.devices.programs.system.task.TaskAdd;
import com.ultreon.devices.programs.system.task.TaskDeposit;
import com.ultreon.devices.programs.system.task.TaskGetBalance;
import com.ultreon.devices.programs.system.task.TaskPay;
import com.ultreon.devices.programs.system.task.TaskRemove;
import com.ultreon.devices.programs.system.task.TaskUpdateApplicationData;
import com.ultreon.devices.programs.system.task.TaskUpdateSystemData;
import com.ultreon.devices.programs.system.task.TaskWithdraw;
import com.ultreon.devices.util.SiteRegistration;
import com.ultreon.devices.util.Vulnerability;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Devices {
    public static final String MOD_ID = "devices";
    public static final class_1761 TAB_DEVICE = CreativeTabRegistry.create((class_2960)Devices.id("devices_mod_tab"), () -> ((class_1792)DeviceItems.LAPTOPS.of(class_1767.field_7964).get()).method_7854());
    public static final Supplier<Registries> REGISTRIES = Suppliers.memoize(() -> Registries.get((String)MOD_ID));
    public static final List<SiteRegistration> SITE_REGISTRATIONS = new ProtectedArrayList<SiteRegistration>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Devices Mod");
    public static final boolean DEVELOPER_MODE = false;
    private static final Pattern DEV_PREVIEW_PATTERN = Pattern.compile("\\d+\\.\\d+\\.\\d+-dev\\d+");
    private static final boolean IS_DEV_PREVIEW = DEV_PREVIEW_PATTERN.matcher(Reference.VERSION).matches();
    private static final String GITWEB_REGISTER_URL = "https://ultreon.gitlab.io/gitweb/site_register.json";
    public static final String VULNERABILITIES_URL = "https://jab125.com/gitweb/vulnerabilities.php";
    private static final boolean PROTECT_FROM_LAUNCH = false;
    private static final SiteRegisterStack SITE_REGISTER_STACK = new SiteRegisterStack();
    static List<AppInfo> allowedApps;
    private static List<Vulnerability> vulnerabilities;
    private static MinecraftServer server;

    public static List<Vulnerability> getVulnerabilities() {
        return vulnerabilities;
    }

    public static void init() {
        if (PlatformMethods.getCurrentTarget().equals("fabric")) {
            Devices.preInit();
            Devices.serverSetup();
        }
        LOGGER.info("Doing some common setup.");
        PacketHandler.init();
        Devices.registerApplications();
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            ClientAppDebug.register();
            ClientModEvents.clientSetup();
        });
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Devices::setupSiteRegistrations);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Devices::checkForVulnerabilities);
        Devices.setupEvents();
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Devices::setupClientEvents);
        if (!PlatformMethods.getCurrentTarget().equals("forge")) {
            Devices.loadComplete();
        }
    }

    public static void preInit() {
        DeviceConfig.init();
    }

    public static boolean isDevelopmentPreview() {
        return IS_DEV_PREVIEW;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void serverSetup() {
        LOGGER.info("Doing some server setup.");
    }

    public static void loadComplete() {
        LOGGER.info("Doing some load complete handling.");
    }

    private static void registerApplications() {
        Devices.registerApplicationEvent();
        TaskManager.registerTask(TaskUpdateApplicationData::new);
        TaskManager.registerTask(TaskPrint::new);
        TaskManager.registerTask(TaskUpdateSystemData::new);
        TaskManager.registerTask(TaskConnect::new);
        TaskManager.registerTask(TaskPing::new);
        TaskManager.registerTask(TaskGetDevices::new);
        TaskManager.registerTask(TaskDeposit::new);
        TaskManager.registerTask(TaskWithdraw::new);
        TaskManager.registerTask(TaskGetBalance::new);
        TaskManager.registerTask(TaskPay::new);
        TaskManager.registerTask(TaskAdd::new);
        TaskManager.registerTask(TaskRemove::new);
        TaskManager.registerTask(TaskSendAction::new);
        TaskManager.registerTask(TaskSetupFileBrowser::new);
        TaskManager.registerTask(TaskGetFiles::new);
        TaskManager.registerTask(TaskGetStructure::new);
        TaskManager.registerTask(TaskGetMainDrive::new);
        TaskManager.registerTask(TaskInstallApp::new);
        TaskManager.registerTask(TaskUpdateInbox::new);
        TaskManager.registerTask(TaskSendEmail::new);
        TaskManager.registerTask(TaskCheckEmailAccount::new);
        TaskManager.registerTask(TaskRegisterEmailAccount::new);
        TaskManager.registerTask(TaskDeleteEmail::new);
        TaskManager.registerTask(TaskViewEmail::new);
        TaskManager.registerTask(TaskAddAuction::new);
        TaskManager.registerTask(TaskGetAuctions::new);
        TaskManager.registerTask(TaskBuyItem::new);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> PrintingManager.registerPrint(new class_2960(MOD_ID, "picture"), PixelPainterApp.PicturePrint.class));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerApplicationEvent() {
        DevicesImpl.registerApplicationEvent();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static List<Application> getAPPLICATIONS() {
        return DevicesImpl.getAPPLICATIONS();
    }

    public static void setAllowedApps(List<AppInfo> allowedApps) {
        Devices.allowedApps = allowedApps;
    }

    @Deprecated
    @Nullable
    public static Application registerApplication(class_2960 identifier, ApplicationSupplier app) {
        if ("minecraft".equals(identifier.method_12836())) {
            throw new IllegalArgumentException("Identifier cannot be \"minecraft\"!");
        }
        if (allowedApps == null) {
            allowedApps = new ArrayList<AppInfo>();
        }
        if (app.isSystem()) {
            allowedApps.add(new AppInfo(identifier, true));
        } else {
            allowedApps.add(new AppInfo(identifier, false));
        }
        AtomicReference<Object> application = new AtomicReference<Object>(null);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            Application appl = app.get().get();
            List<Application> apps = Devices.getAPPLICATIONS();
            assert (apps != null);
            apps.add(appl);
            appl.setInfo(Devices.generateAppInfo(identifier, appl.getClass()));
            application.set(appl);
        });
        return application.get();
    }

    @NotNull
    private static AppInfo generateAppInfo(class_2960 identifier, Class<? extends Application> clazz) {
        LOGGER.debug("Generating app info for " + identifier.toString());
        AppInfo info = new AppInfo(identifier, SystemApp.class.isAssignableFrom(clazz));
        info.reload();
        return info;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Map<String, IPrint.Renderer> getRegisteredRenders() {
        return DevicesImpl.getRegisteredRenders();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void setRegisteredRenders(Map<String, IPrint.Renderer> map) {
        DevicesImpl.setRegisteredRenders(map);
    }

    public static boolean registerPrint(class_2960 identifier, Class<? extends IPrint> classPrint) {
        LOGGER.debug("Registering print: " + identifier.toString());
        try {
            Constructor<? extends IPrint> constructor = classPrint.getConstructor(new Class[0]);
            IPrint print = constructor.newInstance(new Object[0]);
            Class<? extends IPrint.Renderer> classRenderer = print.getRenderer();
            try {
                IPrint.Renderer renderer = classRenderer.getConstructor(new Class[0]).newInstance(new Object[0]);
                Map<String, IPrint.Renderer> idToRenderer = Devices.getRegisteredRenders();
                if (idToRenderer == null) {
                    idToRenderer = new HashMap<String, IPrint.Renderer>();
                    Devices.setRegisteredRenders(idToRenderer);
                }
                idToRenderer.put(identifier.toString(), renderer);
            }
            catch (InstantiationException e) {
                LOGGER.error("The print renderer '" + classRenderer.getName() + "' is missing an empty constructor and could not be registered!");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("The print '" + classPrint.getName() + "' is missing an empty constructor and could not be registered!");
            return false;
        }
    }

    public static void showNotification(class_2487 tag) {
        LOGGER.debug("Showing notification");
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            ClientNotification notification = ClientNotification.loadFromTag(tag);
            notification.push();
        });
    }

    public static boolean hasAllowedApplications() {
        return allowedApps != null;
    }

    public static List<AppInfo> getAllowedApplications() {
        if (allowedApps == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(allowedApps);
    }

    public static class_2960 res(String path) {
        return new class_2960(MOD_ID, path);
    }

    private static void setupClientEvents() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            LOGGER.debug("Client disconnected from server");
            allowedApps = null;
            DeviceConfig.restore();
        });
    }

    private static void setupEvents() {
        LifecycleEvent.SERVER_STARTING.register(instance -> {
            server = instance;
        });
        LifecycleEvent.SERVER_STOPPED.register(instance -> {
            server = null;
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> {
            class_1937 level = player.method_37908();
            if (!player.method_5998(hand).method_7960() && player.method_5998(hand).method_7909() == class_1802.field_8407 && level.method_8320(pos).method_26204() instanceof PrinterBlock) {
                return EventResult.interruptTrue();
            }
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            LOGGER.info("Player logged in: " + player.method_5477());
            if (allowedApps != null) {
                PacketHandler.sendToClient(new SyncApplicationPacket(allowedApps), (class_1657)player);
            }
            PacketHandler.sendToClient(new SyncConfigPacket(), (class_1657)player);
        });
    }

    private static void setupSiteRegistrations() {
        Devices.setupSiteRegistration(GITWEB_REGISTER_URL);
    }

    private static void checkForVulnerabilities() {
        OnlineRequest.getInstance().make(VULNERABILITIES_URL, (success, response) -> {
            if (!success) {
                System.out.println("Could not access vulnerabilities!");
                vulnerabilities = ImmutableList.of();
                return;
            }
            JsonArray array = JsonParser.parseString((String)response).getAsJsonArray();
            vulnerabilities = Vulnerability.parseArray(array);
            System.out.println(array);
            System.out.println(Arrays.toString(Reference.getVerInfo()));
            System.out.println("Vulnerabilities:" + vulnerabilities);
        });
    }

    private static void setupSiteRegistration(String url) {
        SITE_REGISTER_STACK.push();
        OnlineRequest.getInstance().make(url, (success, response) -> {
            if (success) {
                JsonArray array = JsonParser.parseString((String)response).getAsJsonArray();
                block14: for (JsonElement jsonElement : array) {
                    JsonObject elem = jsonElement.getAsJsonObject();
                    String registrant = elem.get("registrant") != null ? elem.get("registrant").getAsString() : null;
                    static enum Type {
                        SITE_REGISTER,
                        REGISTRATION;

                    }
                    Type type = Type.REGISTRATION;
                    JsonElement typeElem = elem.get("type");
                    if (typeElem != null && typeElem.isJsonPrimitive() && typeElem.getAsJsonPrimitive().isString()) {
                        switch (typeElem.getAsString()) {
                            case "registration": {
                                break;
                            }
                            case "site-register": {
                                type = Type.SITE_REGISTER;
                                break;
                            }
                            default: {
                                LOGGER.error("Invalid element type: " + typeElem.getAsString());
                                continue block14;
                            }
                        }
                    }
                    switch (type) {
                        case REGISTRATION: {
                            boolean dev = elem.get("dev") != null ? elem.get("dev").getAsBoolean() : false;
                            String site = elem.get("site").getAsString();
                            if (dev && !IS_DEV_PREVIEW) break;
                            for (JsonElement registration : elem.get("registrations").getAsJsonArray()) {
                                Set a = registration.getAsJsonObject().keySet();
                                JsonObject d = registration.getAsJsonObject();
                                for (String string : a) {
                                    String registrationType = d.get(string).getAsString();
                                    SITE_REGISTRATIONS.add(new SiteRegistration(registrant, string, registrationType, site));
                                }
                            }
                            break;
                        }
                        case SITE_REGISTER: {
                            if (!elem.has("register") || !elem.get("register").isJsonPrimitive() || !elem.get("register").getAsJsonPrimitive().isString()) break;
                            String registerUrl = elem.get("register").getAsString();
                            try {
                                Devices.setupSiteRegistration(registerUrl);
                                break;
                            }
                            catch (Exception e) {
                                LOGGER.error("Error when loading site register: " + registerUrl);
                            }
                        }
                    }
                }
            } else {
                LOGGER.error("Error occurred when loading site registrations at: " + url);
                return;
            }
            SITE_REGISTER_STACK.pop();
        });
    }

    public static class_2960 id(String id) {
        return new class_2960(MOD_ID, id);
    }

    private static /* synthetic */ Supplier lambda$registerApplications$10() {
        return TestApp::new;
    }

    private static /* synthetic */ Supplier lambda$registerApplications$9() {
        return TextAreaApp::new;
    }

    private static /* synthetic */ Supplier lambda$registerApplications$8() {
        return IconsApp::new;
    }

    private static /* synthetic */ Supplier lambda$registerApplications$7() {
        return ExampleApp::new;
    }

    public static interface ApplicationSupplier {
        public Supplier<Application> get();

        public boolean isSystem();
    }

    private static class SiteRegisterStack
    extends Stack<Object> {
        private SiteRegisterStack() {
        }

        public Object push() {
            return super.push(new Object());
        }

        @Override
        public synchronized Object pop() {
            Object pop = super.pop();
            if (this.isEmpty()) {
                ((ProtectedArrayList)SITE_REGISTRATIONS).freeze();
            }
            return pop;
        }
    }

    private static class ProtectedArrayList<T>
    extends ArrayList<T> {
        private final StackWalker stackWalker = StackWalker.getInstance(EnumSet.of(StackWalker.Option.RETAIN_CLASS_REFERENCE));
        private boolean frozen = false;

        private ProtectedArrayList() {
        }

        private void freeze() {
            this.frozen = true;
        }

        private void freezeCheck() {
            if (this.frozen) {
                throw new IllegalStateException("Already frozen!");
            }
        }

        @Override
        public boolean add(T t) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.add(t);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.addAll(c);
        }

        @Override
        public void add(int index, T element) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            super.add(index, element);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            super.removeRange(fromIndex, toIndex);
        }

        @Override
        public boolean remove(Object o) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.remove(o);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.removeAll(c);
        }

        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return super.removeIf(filter);
        }

        @Override
        public T remove(int index) {
            this.freezeCheck();
            if (this.stackWalker.getCallerClass() != Devices.class) {
                throw new IllegalCallerException("Should be called from Devices Mod main class.");
            }
            return (T)super.remove(index);
        }
    }
}

