/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api;

import com.ultreon.devices.Devices;
import com.ultreon.devices.api.app.Application;
import com.ultreon.devices.object.AppInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class ApplicationManager {
    private static final Map<class_2960, AppInfo> APP_INFO = new HashMap<class_2960, AppInfo>();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"ApplicationManager");

    private ApplicationManager() {
    }

    @Nullable
    public static Application registerApplication(class_2960 identifier, final Supplier<Supplier<Application>> app, final boolean isSystem) {
        Devices.LOGGER.debug(MARKER, "Registering application {}", (Object)identifier);
        Application application = Devices.registerApplication(identifier, new Devices.ApplicationSupplier(){

            @Override
            public Supplier<Application> get() {
                return (Supplier)app.get();
            }

            @Override
            public boolean isSystem() {
                return isSystem;
            }
        });
        if (application != null) {
            APP_INFO.put(identifier, application.getInfo());
            return application;
        }
        return null;
    }

    public static List<AppInfo> getAvailableApplications() {
        Predicate<AppInfo> FILTER = info -> !info.isSystemApp() && (!Devices.hasAllowedApplications() || Devices.getAllowedApplications().contains(info));
        return APP_INFO.values().stream().filter(FILTER).collect(Collectors.toList());
    }

    public static List<AppInfo> getSystemApplications() {
        return APP_INFO.values().stream().filter(AppInfo::isSystemApp).collect(Collectors.toList());
    }

    public static List<AppInfo> getAllApplications() {
        return new ArrayList<AppInfo>(APP_INFO.values());
    }

    @Nullable
    public static AppInfo getApplication(class_2960 appId) {
        return APP_INFO.get(appId);
    }
}

