/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.component.RadioGroup;
import com.ultreon.devices.api.app.listener.ClickListener;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class CheckBox
extends Component
implements RadioGroup.Item {
    protected String name;
    protected boolean checked = false;
    protected RadioGroup group = null;
    protected ClickListener listener = null;
    protected int textColor = Color.WHITE.getRGB();
    protected int backgroundColor = Color.GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();
    protected int checkedColor = Color.DARK_GRAY.getRGB();

    public CheckBox(String name, int left, int top) {
        super(left, top);
        this.name = name;
    }

    public void setRadioGroup(RadioGroup group) {
        this.group = group;
        this.group.add(this);
    }

    public void setClickListener(ClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            if (this.group == null) {
                Color bgColor = new Color(this.getColorScheme().getBackgroundColor());
                CheckBox.method_25294((class_4587)pose, (int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + 10), (int)(this.yPosition + 10), (int)CheckBox.color(this.borderColor, bgColor.darker().darker().getRGB()));
                CheckBox.method_25294((class_4587)pose, (int)(this.xPosition + 1), (int)(this.yPosition + 1), (int)(this.xPosition + 9), (int)(this.yPosition + 9), (int)CheckBox.color(this.backgroundColor, bgColor.getRGB()));
                if (this.checked) {
                    CheckBox.method_25294((class_4587)pose, (int)(this.xPosition + 2), (int)(this.yPosition + 2), (int)(this.xPosition + 8), (int)(this.yPosition + 8), (int)CheckBox.color(this.checkedColor, bgColor.brighter().brighter().getRGB()));
                }
            } else {
                Color bgColor = new Color(this.getColorScheme().getBackgroundColor()).brighter().brighter();
                float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
                bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
                RenderSystem.setShaderColor((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)COMPONENTS_GUI);
                this.method_25302(pose, this.xPosition, this.yPosition, this.checked ? 10 : 0, 60, 10, 10);
            }
            CheckBox.method_25303((class_4587)pose, (class_327)mc.field_1772, (String)this.name, (int)(this.xPosition + 12), (int)(this.yPosition + 1), (int)CheckBox.color(this.textColor, this.getColorScheme().getTextColor()));
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + 10, this.yPosition + 10)) {
            if (this.group != null) {
                this.group.deselect();
            }
            boolean bl = this.checked = !this.checked;
            if (this.listener != null) {
                this.listener.onClick(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.checked;
    }

    @Override
    public void setSelected(boolean enabled) {
        this.checked = enabled;
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color.getRGB();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setCheckedColor(Color color) {
        this.checkedColor = color.getRGB();
    }
}

