/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.app.component;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.IIcon;
import com.ultreon.devices.api.app.Layout;
import com.ultreon.devices.api.app.component.Spinner;
import com.ultreon.devices.api.utils.OnlineRequest;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1049;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Image
extends Component {
    public static final Map<String, CachedImage> CACHE = new HashMap<String, CachedImage>();
    protected ImageLoader loader;
    protected CachedImage image;
    protected boolean initialized = false;
    protected boolean drawFull = false;
    protected int imageU;
    protected int imageV;
    protected int imageWidth;
    protected int imageHeight;
    protected int sourceWidth;
    protected int sourceHeight;
    public int componentWidth;
    public int componentHeight;
    private Spinner spinner;
    private float alpha = 1.0f;
    private Supplier<ColorSupplier> tint = () -> (ColorSupplier)class_156.method_654((Object)new ColorSupplier(), cs -> {
        cs.r = 255;
        cs.g = 255;
        cs.b = 255;
    });
    private boolean hasBorder = false;
    private int borderColor = Color.BLACK.getRGB();
    private int borderThickness = 0;
    private int _pBorderThickness = 1;

    public void setTint(int r, int g, int b) {
        ColorSupplier cs = new ColorSupplier();
        cs.r = r;
        cs.g = g;
        cs.b = b;
        this.setTint(() -> cs);
    }

    public void setTint(Supplier<ColorSupplier> colorSupplier) {
        this.tint = colorSupplier;
    }

    public Image(int left, int top, int width, int height) {
        super(left, top);
        this.componentWidth = width;
        this.componentHeight = height;
    }

    public Image(int left, int top, int imageU, int imageV, int imageWidth, int imageHeight, class_2960 resource) {
        this(left, top, imageWidth, imageHeight, imageU, imageV, imageWidth, imageHeight, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, class_2960 resource) {
        this(left, top, componentWidth, componentHeight, imageU, imageV, imageWidth, imageHeight, 256, 256, resource);
    }

    public Image(int left, int top, int componentWidth, int componentHeight, int imageU, int imageV, int imageWidth, int imageHeight, int sourceWidth, int sourceHeight, class_2960 resource) {
        super(left, top);
        this.loader = new StandardLoader(resource);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = imageU;
        this.imageV = imageV;
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
    }

    public Image(int left, int top, int componentWidth, int componentHeight, String url) {
        super(left, top);
        this.loader = new DynamicLoader(url);
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.drawFull = true;
    }

    public Image(int left, int top, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = icon.getIconSize();
        this.componentHeight = icon.getIconSize();
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    public Image(int left, int top, int componentWidth, int componentHeight, IIcon icon) {
        super(left, top);
        this.loader = new StandardLoader(icon.getIconAsset());
        this.componentWidth = componentWidth;
        this.componentHeight = componentHeight;
        this.imageU = icon.getU();
        this.imageV = icon.getV();
        this.imageWidth = icon.getIconSize();
        this.imageHeight = icon.getIconSize();
        this.sourceWidth = icon.getGridWidth() * icon.getIconSize();
        this.sourceHeight = icon.getGridHeight() * icon.getIconSize();
    }

    @Override
    public void init(Layout layout) {
        if (layout != null) {
            this.spinner = new Spinner(this.left + this.componentWidth / 2 - 6, this.top + this.componentHeight / 2 - 6);
            layout.addComponent(this.spinner);
        }
        this.initialized = true;
    }

    @Override
    public void handleLoad() {
        this.reload();
    }

    @Override
    protected void handleUnload() {
        this.initialized = false;
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            if (this.loader != null && this.loader.setup) {
                this.image = this.loader.load(this);
                this.spinner.setVisible(false);
                this.loader.setup = false;
            }
            if (this.hasBorder) {
                Image.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + this.componentWidth), (int)(y + this.componentHeight), (int)this.borderColor);
            }
            RenderSystem.setShaderColor((float)((float)this.tint.get().r / 255.0f), (float)((float)this.tint.get().g / 255.0f), (float)((float)this.tint.get().b / 255.0f), (float)this.alpha);
            if (this.image != null && this.image.textureId != -1) {
                this.image.restore();
                RenderSystem.setShaderColor((float)((float)this.tint.get().r / 255.0f), (float)((float)this.tint.get().g / 255.0f), (float)((float)this.tint.get().b / 255.0f), (float)this.alpha);
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (int)this.image.textureId);
                if (this.drawFull) {
                    RenderUtil.drawRectWithTexture(pose, x + this.borderThickness, y + this.borderThickness, 0.0, this.imageU, this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2, 256.0f, 256.0f);
                } else {
                    RenderUtil.drawRectWithTexture(pose, x + this.borderThickness, y + this.borderThickness, this.imageU, this.imageV, this.componentWidth - this.borderThickness * 2, this.componentHeight - this.borderThickness * 2, this.imageWidth, this.imageHeight, this.sourceWidth, this.sourceHeight);
                }
            } else {
                Image.method_25294((class_4587)pose, (int)(x + this.borderThickness), (int)(y + this.borderThickness), (int)(x + this.componentWidth - this.borderThickness), (int)(y + this.componentHeight - this.borderThickness), (int)Color.LIGHT_GRAY.getRGB());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
    }

    public void reload() {
        if (this.loader != null) {
            this.loader.setup(this);
        }
    }

    public void setImage(class_2960 resource) {
        this.setLoader(new StandardLoader(resource));
        this.drawFull = true;
    }

    public void setImage(Laptop.Wallpaper wallpaper) {
        if (wallpaper.isBuiltIn()) {
            this.setImage(Laptop.getWallpapers().get(wallpaper.getLocation()));
        } else {
            this.setImage(wallpaper.getUrl());
        }
    }

    public void setImage(String url) {
        this.setLoader(new DynamicLoader(url));
        this.drawFull = true;
    }

    private void setLoader(ImageLoader loader) {
        this.loader = loader;
        if (this.initialized) {
            loader.setup(this);
            this.spinner.setVisible(true);
        }
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f) {
            this.alpha = 0.0f;
            return;
        }
        if (alpha > 1.0f) {
            this.alpha = 1.0f;
            return;
        }
        this.alpha = alpha;
    }

    public void setBorderVisible(boolean show) {
        this.hasBorder = show;
        this.borderThickness = show ? this._pBorderThickness : 0;
    }

    private void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setBorderThickness(int thickness) {
        this._pBorderThickness = thickness;
        this.borderThickness = thickness;
    }

    public void setDrawFull(boolean drawFull) {
        this.drawFull = drawFull;
    }

    private static class ColorSupplier {
        int r;
        int g;
        int b;

        private ColorSupplier() {
        }
    }

    private static class StandardLoader
    extends ImageLoader {
        private final class_1044 texture;
        private final class_2960 resource;

        public StandardLoader(class_2960 resource) {
            this.texture = new class_1049(resource);
            this.resource = resource;
        }

        @Override
        protected void setup(Image image) {
            this.setup = true;
        }

        @Override
        public CachedImage load(Image image) {
            @Nullable class_1044 textureObj = class_310.method_1551().method_1531().method_34590(this.resource, null);
            if (textureObj != null) {
                return new CachedImage(textureObj.method_4624(), 0, 0, false);
            }
            class_1049 texture = new class_1049(this.resource);
            class_310.method_1551().method_1531().method_4616(this.resource, (class_1044)texture);
            return new CachedImage(texture.method_4624(), 0, 0, false);
        }

        public class_1044 getTexture() {
            return this.texture;
        }
    }

    private static abstract class ImageLoader {
        protected boolean setup = false;

        private ImageLoader() {
        }

        public final boolean isSetup() {
            return this.setup;
        }

        protected void setup(Image image) {
            this.setup = false;
        }

        public abstract CachedImage load(Image var1);
    }

    private static class DynamicLoader
    extends ImageLoader {
        private final String url;
        private class_1044 texture;

        public DynamicLoader(String url) {
            this.url = url;
        }

        @Override
        public void setup(Image image) {
            if (CACHE.containsKey(this.url)) {
                this.setup = true;
                return;
            }
            Runnable r = () -> {
                try {
                    URL url = new URL(this.url);
                    OnlineRequest.checkURLForSuspicions(url);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0");
                    InputStream connIn = conn.getInputStream();
                    byte[] bytes = connIn.readAllBytes();
                    connIn.close();
                    conn.disconnect();
                    ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                    ByteArrayInputStream imageIn = new ByteArrayInputStream(bytes);
                    BufferedImage img = ImageIO.read(imageIn);
                    class_1011 nativeImage = class_1011.method_4309((InputStream)in);
                    Laptop.runLater(() -> {
                        Devices.LOGGER.debug("Loaded image: " + url);
                        this.texture = new class_1043(nativeImage);
                        this.setup = true;
                    });
                }
                catch (IOException e) {
                    this.texture = class_1047.method_4540();
                    this.setup = true;
                    e.printStackTrace();
                }
            };
            Thread thread = new Thread(r, "Image Loader");
            thread.start();
        }

        @Override
        public CachedImage load(Image image) {
            if (CACHE.containsKey(this.url)) {
                CachedImage cachedImage = CACHE.get(this.url);
                image.imageWidth = cachedImage.width;
                image.imageHeight = cachedImage.height;
                return cachedImage;
            }
            try {
                this.texture.method_4625(class_310.method_1551().method_1478());
                CachedImage cachedImage = new CachedImage(this.texture.method_4624(), image.imageWidth, image.imageHeight, true);
                if (this.texture != class_1047.method_4540()) {
                    CACHE.put(this.url, cachedImage);
                }
                return cachedImage;
            }
            catch (IOException e) {
                return new CachedImage(class_1047.method_4540().method_4624(), 0, 0, true);
            }
        }
    }

    public static class CachedImage {
        private final int textureId;
        private final int width;
        private final int height;
        private final boolean dynamic;
        private boolean delete = false;

        private CachedImage(int textureId, int width, int height, boolean dynamic) {
            this.textureId = textureId;
            this.width = width;
            this.height = height;
            this.dynamic = dynamic;
        }

        public int getTextureId() {
            return this.textureId;
        }

        public void restore() {
            this.delete = false;
        }

        public void delete() {
            this.delete = true;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }

        public boolean isPendingDeletion() {
            return this.delete;
        }
    }

    private static class ImageCache
    extends LinkedHashMap<String, CachedImage> {
        private final int CAPACITY;

        private ImageCache(int capacity) {
            super(capacity, 1.0f, true);
            this.CAPACITY = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedImage> eldest) {
            if (this.size() > this.CAPACITY) {
                eldest.getValue().delete = true;
                return true;
            }
            return false;
        }
    }

    private static class DynamicLoadedTexture
    extends class_1044 {
        private final InputStream in;
        private final BufferedImage image;

        private DynamicLoadedTexture(InputStream in, BufferedImage image) {
            this.in = in;
            this.image = image;
            TextureUtil.prepareImage((int)this.method_4624(), (int)this.image.getWidth(), (int)this.image.getHeight());
        }

        public void method_4625(@NotNull class_3300 resourceManager) throws IOException {
            class_1011 nativeImage = class_1011.method_4309((InputStream)this.in);
            class_310.method_1551().method_1531().method_4616(Devices.id("dynamic_loaded/" + this.method_4624()), (class_1044)this);
            this.upload(nativeImage);
        }

        private void upload(class_1011 nativeImage) {
            nativeImage.method_4301(0, 0, 0, this.field_5203);
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }

    public static class AppImage
    extends Layout {
        private final AppInfo appInfo;
        private AppInfo.Icon.Glyph[] glyphs;
        private int componentWidth;
        private int componentHeight;

        public AppImage(int left, int top, AppInfo resource) {
            this(left, top, 14, 14, resource);
            this.glyphs = new AppInfo.Icon.Glyph[]{resource.getIcon().getBase(), resource.getIcon().getOverlay0(), resource.getIcon().getOverlay1()};
        }

        public AppImage(int left, int top, int componentWidth, int componentHeight, AppInfo resource) {
            super(left, top, componentWidth, componentHeight);
            this.appInfo = resource;
            this.glyphs = new AppInfo.Icon.Glyph[]{resource.getIcon().getBase(), resource.getIcon().getOverlay0(), resource.getIcon().getOverlay1()};
            this.componentWidth = componentWidth;
            this.componentHeight = componentHeight;
        }

        @Override
        public void init(Layout layout) {
            super.init(layout);
            if (this.appInfo.getIcon().getBase().getU() == -1 && this.appInfo.getIcon().getBase().getV() == -1) {
                Image image = new Image(0, 0, this.componentWidth, this.componentHeight, 0, 0, 14, 14, 224, 224, Laptop.ICON_TEXTURES);
                this.addComponent(image);
                return;
            }
            for (AppInfo.Icon.Glyph glyph : this.glyphs) {
                if (glyph.getU() == -1 || glyph.getV() == -1) continue;
                Image image = new Image(0, 0, this.componentWidth, this.componentHeight, glyph.getU(), glyph.getV(), 14, 14, 224, 224, Laptop.ICON_TEXTURES);
                Supplier<ColorSupplier> suscs = () -> {
                    int tint = this.appInfo.getTint(glyph.getType());
                    Color col = new Color(tint);
                    ColorSupplier cs = new ColorSupplier();
                    cs.r = col.getRed();
                    cs.g = col.getGreen();
                    cs.b = col.getBlue();
                    return cs;
                };
                image.setTint(suscs);
                this.addComponent(image);
            }
        }
    }
}

