/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.app.component;

import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.core.Laptop;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class ProgressBar
extends Component {
    protected int width;
    protected int height;
    protected int progress = 0;
    protected int max = 100;
    protected int progressColor = new Color(189, 198, 255).getRGB();
    protected int backgroundColor = Color.DARK_GRAY.getRGB();
    protected int borderColor = Color.BLACK.getRGB();

    public ProgressBar(int left, int top, int width, int height) {
        super(left, top);
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            Color bgColor = new Color(this.getColorScheme().getBackgroundColor());
            ProgressBar.method_25294((class_4587)pose, (int)this.xPosition, (int)this.yPosition, (int)(this.xPosition + this.width), (int)(this.yPosition + this.height), (int)bgColor.darker().darker().getRGB());
            ProgressBar.method_25294((class_4587)pose, (int)(this.xPosition + 1), (int)(this.yPosition + 1), (int)(this.xPosition + this.width - 1), (int)(this.yPosition + this.height - 1), (int)bgColor.getRGB());
            ProgressBar.method_25294((class_4587)pose, (int)(this.xPosition + 2), (int)(this.yPosition + 2), (int)(this.xPosition + 2 + this.getProgressScaled()), (int)(this.yPosition + this.height - 2), (int)bgColor.brighter().brighter().getRGB());
        }
    }

    private int getProgressScaled() {
        return (int)Math.ceil((double)(this.width - 4) * ((double)this.progress / (double)this.max));
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress > this.max) {
            progress = this.max;
        } else if (progress < 0) {
            progress = 0;
        }
        this.progress = progress;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
        }
    }
}

