/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.app.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.api.app.Component;
import com.ultreon.devices.api.app.interfaces.IHighlight;
import com.ultreon.devices.api.app.listener.KeyListener;
import com.ultreon.devices.api.utils.RenderUtil;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.util.GLHelper;
import com.ultreon.devices.util.GuiHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class TextArea
extends Component {
    private static final String UNFORMATTED_SPLIT = "(?<=%1$s)|(?=%1$s)";
    private static final String[] DELIMITERS = new String[]{"(\\s|$)(?=(([^\"]*\"){2})*[^\"]*$)", "[\\p{Punct}&&[^@\"]]", "\\p{Digit}+"};
    private static final String SPLIT_REGEX;
    protected class_327 font;
    protected String text = "";
    protected String placeholder = null;
    protected int width;
    protected int height;
    protected int placeholderColor = new Color(1.0f, 1.0f, 1.0f, 0.35f).getRGB();
    protected int textColor = this.getColorScheme().getTextColor();
    protected int backgroundColor = this.getColorScheme().getBackgroundColor();
    protected int secondaryBackgroundColor = this.getColorScheme().getBackgroundSecondaryColor();
    protected int borderColor = Color.BLACK.getRGB();
    private int padding = 4;
    private boolean isFocused = false;
    private boolean editable = true;
    private List<String> lines = new ArrayList<String>();
    private int visibleLines;
    private int maxLines;
    private ScrollBar scrollBar;
    private boolean scrollBarVisible = true;
    private int scrollBarSize = 3;
    private int horizontalScroll;
    private int verticalScroll;
    private int horizontalOffset;
    private int verticalOffset;
    private int cursorTick = 0;
    private int cursorX;
    private int cursorY;
    private int clickedX;
    private int clickedY;
    private boolean wrapText = false;
    private int maxLineWidth;
    private IHighlight highlight = null;
    private KeyListener keyListener = null;

    public TextArea(int left, int top, int width, int height) {
        super(left, top);
        this.font = Laptop.getFont();
        this.width = width;
        this.height = height;
        Objects.requireNonNull(this.font);
        this.visibleLines = (int)Math.floor((height - this.padding * 2 + 1) / 9);
        this.lines.add("");
    }

    @Override
    public void handleTick() {
        ++this.cursorTick;
    }

    @Override
    public void render(class_4587 pose, Laptop laptop, class_310 mc, int x, int y, int mouseX, int mouseY, boolean windowActive, float partialTicks) {
        if (this.visible) {
            float linesPerUnit;
            int scroll;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color bgColor = new Color(this.backgroundColor);
            class_329.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + this.width), (int)(y + this.height), (int)bgColor.darker().darker().getRGB());
            class_329.method_25294((class_4587)pose, (int)(x + 1), (int)(y + 1), (int)(x + this.width - 1), (int)(y + this.height - 1), (int)bgColor.getRGB());
            if (!this.isFocused && this.placeholder != null && (this.lines.isEmpty() || this.lines.size() == 1 && this.lines.get(0).isEmpty())) {
                RenderSystem.enableBlend();
                RenderUtil.drawStringClipped(pose, this.placeholder, x + this.padding, y + this.padding, this.width - this.padding * 2, this.placeholderColor, false);
            }
            GLHelper.pushScissor(x + this.padding, y + this.padding, this.width - this.padding * 2, this.height - this.padding * 2);
            for (int i = 0; i < this.visibleLines && i + this.verticalScroll < this.lines.size(); ++i) {
                float scrollPercentage = (float)(this.verticalScroll + this.verticalOffset) / (float)(this.lines.size() - this.visibleLines);
                float pixelsPerUnit = (float)this.maxLineWidth / (float)(this.width - this.padding * 2);
                int scrollX = class_3532.method_15340((int)(this.horizontalScroll + (int)((float)this.horizontalOffset * pixelsPerUnit)), (int)0, (int)Math.max(0, this.maxLineWidth - (this.width - this.padding * 2)));
                int scrollY = (int)((float)(this.lines.size() - this.visibleLines) * scrollPercentage);
                int lineY = i + class_3532.method_15340((int)scrollY, (int)0, (int)Math.max(0, this.lines.size() - this.visibleLines));
                if (this.highlight != null) {
                    String[] words = this.lines.get(lineY).split(SPLIT_REGEX);
                    StringBuilder builder = new StringBuilder();
                    for (String word : words) {
                        class_124[] formatting;
                        for (class_124 format : formatting = this.highlight.getKeywordFormatting(word)) {
                            builder.append(format);
                        }
                        builder.append(word);
                        builder.append(class_124.field_1070);
                    }
                    String string = builder.toString();
                    float f = x + this.padding - scrollX;
                    Objects.requireNonNull(this.font);
                    this.font.method_1729(pose, string, f, (float)(y + this.padding + i * 9), -1);
                    continue;
                }
                float f = x + this.padding - scrollX;
                Objects.requireNonNull(this.font);
                this.font.method_1729(pose, this.lines.get(lineY), f, (float)(y + this.padding + i * 9), this.textColor);
            }
            GLHelper.popScissor();
            GLHelper.pushScissor(x + this.padding, y + this.padding - 1, this.width - this.padding * 2 + 1, this.height - this.padding * 2 + 1);
            if (this.editable && this.isFocused && this.cursorY >= (scroll = class_3532.method_15340((int)(this.verticalScroll + this.verticalOffset * (int)(linesPerUnit = (float)this.lines.size() / (float)this.visibleLines)), (int)0, (int)Math.max(0, this.lines.size() - this.visibleLines))) && this.cursorY < scroll + this.visibleLines && this.cursorTick / 10 % 2 == 0) {
                String subString = this.getActiveLine().substring(0, this.cursorX);
                int visibleWidth = this.width - this.padding * 2;
                float pixelsPerUnit = (float)this.maxLineWidth / (float)(this.width - this.padding * 2);
                int stringWidth = this.font.method_1727(subString);
                int posX = x + this.padding + stringWidth - class_3532.method_15340((int)(this.horizontalScroll + (int)((float)this.horizontalOffset * pixelsPerUnit)), (int)0, (int)Math.max(0, this.maxLineWidth - visibleWidth));
                Objects.requireNonNull(this.font);
                int posY = y + this.padding + (this.cursorY - scroll) * 9;
                Objects.requireNonNull(this.font);
                class_329.method_25294((class_4587)pose, (int)posX, (int)(posY - 1), (int)(posX + 1), (int)(posY + 9), (int)Color.WHITE.getRGB());
            }
            GLHelper.popScissor();
            if (this.scrollBarVisible) {
                if (this.lines.size() > this.visibleLines) {
                    int visibleScrollBarHeight = this.height - 4;
                    int scrollBarHeight = Math.max(20, (int)((float)this.visibleLines / (float)this.lines.size() * (float)visibleScrollBarHeight));
                    float scrollPercentage = class_3532.method_15363((float)((float)(this.verticalScroll + this.verticalOffset) / (float)(this.lines.size() - this.visibleLines)), (float)0.0f, (float)1.0f);
                    int scrollBarY = (int)((float)(visibleScrollBarHeight - scrollBarHeight) * scrollPercentage);
                    int scrollY = this.yPosition + 2 + scrollBarY;
                    class_329.method_25294((class_4587)pose, (int)(x + this.width - 2 - this.scrollBarSize), (int)scrollY, (int)(x + this.width - 2), (int)(scrollY + scrollBarHeight), (int)this.placeholderColor);
                }
                if (!this.wrapText && this.maxLineWidth >= this.width - this.padding * 2) {
                    int visibleWidth = this.width - this.padding * 2;
                    int visibleScrollBarWidth = this.width - 4 - (this.lines.size() > this.visibleLines ? this.scrollBarSize + 1 : 0);
                    float scrollPercentage = (float)(this.horizontalScroll + 1) / (float)(this.maxLineWidth - visibleWidth + 1);
                    int scrollBarWidth = Math.max(20, (int)((float)visibleWidth / (float)this.maxLineWidth * (float)visibleScrollBarWidth));
                    int relativeScrollX = (int)(scrollPercentage * (float)(visibleScrollBarWidth - scrollBarWidth));
                    int scrollX = this.xPosition + 2 + class_3532.method_15340((int)(relativeScrollX + this.horizontalOffset), (int)0, (int)(visibleScrollBarWidth - scrollBarWidth));
                    class_329.method_25294((class_4587)pose, (int)scrollX, (int)(y + this.height - this.scrollBarSize - 2), (int)(scrollX + scrollBarWidth), (int)(y + this.height - 2), (int)this.placeholderColor);
                }
            }
        }
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.visible || !this.enabled) {
            return;
        }
        ScrollBar scrollBar = this.isMouseInsideScrollBar(mouseX, mouseY);
        if (scrollBar != null) {
            this.scrollBar = scrollBar;
            switch (scrollBar) {
                case HORIZONTAL: {
                    this.clickedX = mouseX;
                    break;
                }
                case VERTICAL: {
                    this.clickedY = mouseY;
                }
            }
            return;
        }
        if (!this.editable) {
            return;
        }
        this.isFocused = GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height);
        if (GuiHelper.isMouseWithin(mouseX, mouseY, this.xPosition + this.padding, this.yPosition + this.padding, this.width - this.padding * 2, this.height - this.padding * 2)) {
            int lineX = mouseX - this.xPosition - this.padding + this.horizontalScroll;
            Objects.requireNonNull(this.font);
            int lineY = (mouseY - this.yPosition - this.padding) / 9 + this.verticalScroll;
            if (lineY >= this.lines.size()) {
                this.cursorX = this.lines.get(Math.max(0, this.lines.size() - 1)).length();
                this.cursorY = this.lines.size() - 1;
            } else {
                this.cursorX = this.getClosestLineIndex(lineX, class_3532.method_15340((int)lineY, (int)0, (int)(this.lines.size() - 1)));
                this.cursorY = lineY;
            }
            this.cursorTick = 0;
            this.updateScroll();
        }
    }

    @Override
    protected void handleMouseDrag(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollBar != null) {
            switch (this.scrollBar) {
                case HORIZONTAL: {
                    this.horizontalOffset = mouseX - this.clickedX;
                    break;
                }
                case VERTICAL: {
                    int visibleScrollBarHeight = this.height - 4;
                    int scrollBarHeight = Math.max(20, (int)((float)this.visibleLines / (float)this.lines.size() * (float)visibleScrollBarHeight));
                    float spacing = (float)(visibleScrollBarHeight - scrollBarHeight) / (float)(this.lines.size() - this.visibleLines);
                    this.verticalOffset = (int)((float)(mouseY - this.clickedY) / spacing);
                }
            }
        }
    }

    @Override
    protected void handleMouseRelease(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollBar != null) {
            switch (this.scrollBar) {
                case HORIZONTAL: {
                    float scrollPercentage = (float)this.maxLineWidth / (float)(this.width - this.padding * 2);
                    this.horizontalScroll = class_3532.method_15340((int)(this.horizontalScroll + (int)((float)this.horizontalOffset * scrollPercentage)), (int)0, (int)(this.maxLineWidth - (this.width - this.padding * 2)));
                    break;
                }
                case VERTICAL: {
                    float scrollPercentage = class_3532.method_15363((float)((float)(this.verticalScroll + this.verticalOffset) / (float)(this.lines.size() - this.visibleLines)), (float)0.0f, (float)1.0f);
                    this.verticalScroll = (int)((float)(this.lines.size() - this.visibleLines) * scrollPercentage);
                }
            }
            this.horizontalOffset = 0;
            this.verticalOffset = 0;
            this.scrollBar = null;
        }
    }

    @Override
    public void handleCharTyped(char codePoint, int modifiers) {
        if (!(this.visible && this.enabled && this.isFocused && this.editable)) {
            return;
        }
        System.out.println("TextArea.handleCharTyped: codePoint = " + codePoint + ", modifiers = " + modifiers);
        if (codePoint == '\\') {
            this.performBackspace();
        } else if (Character.isDefined(codePoint)) {
            this.writeText(codePoint);
        }
        if (this.keyListener != null) {
            this.keyListener.onCharTyped(codePoint);
        }
        this.updateScroll();
    }

    @Override
    public void handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(this.visible && this.enabled && this.isFocused && this.editable)) {
            return;
        }
        System.out.println("TextArea.handleKeyPressed: keyCode = " + keyCode + ", scanCode = " + scanCode + ", modifiers = " + modifiers);
        if (class_437.method_25437((int)keyCode)) {
            String[] lines = class_310.method_1551().field_1774.method_1460().split("\n");
            for (int i = 0; i < lines.length - 1; ++i) {
                this.writeText(lines[i] + "\n");
            }
            this.writeText(lines[lines.length - 1]);
        } else {
            System.out.println("TextArea.handleKeyTypes: keyCode = " + keyCode);
            switch (keyCode) {
                case 259: {
                    this.performBackspace();
                    break;
                }
                case 257: {
                    this.performReturn();
                    break;
                }
                case 258: {
                    this.writeText('\t');
                    break;
                }
                case 263: {
                    this.moveCursorLeft(1);
                    break;
                }
                case 262: {
                    this.moveCursorRight(1);
                    break;
                }
                case 265: {
                    this.moveCursorUp();
                    break;
                }
                case 264: {
                    this.moveCursorDown();
                }
            }
        }
        this.updateScroll();
    }

    @Override
    protected void handleMouseScroll(int mouseX, int mouseY, boolean direction) {
        if (GuiHelper.isMouseInside(mouseX, mouseY, this.xPosition, this.yPosition, this.xPosition + this.width, this.yPosition + this.height)) {
            this.scroll(direction ? -1 : 1);
        }
    }

    @Nullable
    private ScrollBar isMouseInsideScrollBar(int mouseX, int mouseY) {
        int posY;
        int scrollBarWidth;
        int visibleScrollBarWidth;
        int visibleWidth;
        float scrollPercentage;
        int relativeScrollX;
        int posX;
        if (!this.scrollBarVisible) {
            return null;
        }
        if (this.lines.size() > this.visibleLines) {
            int scrollBarHeight;
            int visibleScrollBarHeight = this.height - 4;
            int posX2 = this.xPosition + this.width - 2 - this.scrollBarSize;
            float scrollPercentage2 = (float)this.verticalScroll / (float)(this.lines.size() - this.visibleLines);
            int relativeScrollY = (int)(scrollPercentage2 * (float)(visibleScrollBarHeight - (scrollBarHeight = Math.max(20, (int)((float)this.visibleLines / (float)this.lines.size() * (float)visibleScrollBarHeight)))));
            int posY2 = this.yPosition + 2 + class_3532.method_15340((int)(relativeScrollY + this.verticalOffset), (int)0, (int)(visibleScrollBarHeight - scrollBarHeight));
            if (GuiHelper.isMouseInside(mouseX, mouseY, posX2, posY2, posX2 + this.scrollBarSize, posY2 + scrollBarHeight)) {
                return ScrollBar.VERTICAL;
            }
        }
        if (!this.wrapText && this.maxLineWidth >= this.width - this.padding * 2 && GuiHelper.isMouseInside(mouseX, mouseY, posX = this.xPosition + 2 + class_3532.method_15340((int)(relativeScrollX = (int)((scrollPercentage = (float)this.horizontalScroll / (float)(this.maxLineWidth - (visibleWidth = this.width - this.padding * 2) + 1)) * (float)((visibleScrollBarWidth = this.width - 4 - (this.lines.size() > this.visibleLines ? this.scrollBarSize + 1 : 0)) - (scrollBarWidth = Math.max(20, (int)((float)visibleWidth / (float)this.maxLineWidth * (float)visibleScrollBarWidth)))))), (int)0, (int)(visibleScrollBarWidth - scrollBarWidth)), posY = this.yPosition + this.height - 2 - this.scrollBarSize, posX + scrollBarWidth, posY + this.scrollBarSize)) {
            return ScrollBar.HORIZONTAL;
        }
        return null;
    }

    private String getActiveLine() {
        return this.lines.get(this.cursorY);
    }

    public void performBackspace() {
        if (this.cursorY == 0 && this.cursorX == 0) {
            return;
        }
        this.removeCharAtCursor();
        if (this.wrapText && this.cursorY + 1 < this.lines.size()) {
            String activeLine = this.getActiveLine();
            if (activeLine.contains("\n")) {
                return;
            }
            String result = activeLine + this.lines.remove(this.cursorY + 1);
            if (this.font.method_1727(result) > this.width - this.padding * 2) {
                String trimmed = this.font.method_27523(result, this.width - this.padding * 2);
                this.lines.set(this.cursorY, trimmed);
                if (trimmed.charAt(trimmed.length() - 1) != '\n') {
                    this.prependToLine(this.cursorY + 1, result.substring(trimmed.length()));
                } else if (this.cursorY + 1 < this.lines.size()) {
                    this.lines.add(this.cursorY + 1, trimmed);
                } else {
                    this.lines.add(trimmed);
                }
            } else {
                this.lines.set(this.cursorY, result);
            }
        }
        this.recalculateMaxWidth();
    }

    public void performReturn() {
        if (this.maxLines > 0 && this.getNewLineCount() == this.maxLines - 1) {
            return;
        }
        int lineIndex = this.cursorY;
        String activeLine = this.getActiveLine();
        if (this.cursorX == activeLine.length()) {
            this.lines.set(lineIndex, activeLine + "\n");
            if (!this.wrapText || lineIndex + 1 == this.lines.size()) {
                this.lines.add(lineIndex + 1, "");
            }
        } else {
            this.lines.set(lineIndex, activeLine.substring(0, this.cursorX) + "\n");
            this.lines.add(lineIndex + 1, activeLine.substring(this.cursorX));
        }
        if (this.cursorY + 1 >= this.verticalScroll + this.visibleLines) {
            this.scroll(1);
        }
        this.moveCursorRight(1);
        this.recalculateMaxWidth();
    }

    private int getNewLineCount() {
        int count = 0;
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            if (!this.lines.get(i).endsWith("\n")) continue;
            ++count;
        }
        return count;
    }

    private void removeCharAtCursor() {
        String activeLine = this.getActiveLine();
        if (this.cursorX > 0) {
            String head = activeLine.substring(0, this.cursorX - 1);
            String tail = activeLine.substring(this.cursorX);
            this.lines.set(this.cursorY, head + tail);
            this.moveCursorLeft(1);
            return;
        }
        if (this.wrapText) {
            if (activeLine.isEmpty()) {
                this.lines.remove(this.cursorY);
            }
            String previousLine = this.lines.get(this.cursorY - 1);
            this.lines.set(this.cursorY - 1, previousLine.substring(0, Math.max(previousLine.length() - 1, 0)));
            this.moveCursorLeft(1);
        } else {
            String previousLine = this.lines.get(this.cursorY - 1);
            this.moveCursorLeft(1);
            String substring = previousLine.substring(0, Math.max(previousLine.length() - 1, 0));
            if (!activeLine.isEmpty()) {
                this.lines.set(this.cursorY, substring + activeLine);
            } else {
                this.lines.set(this.cursorY, substring);
            }
            this.lines.remove(this.cursorY + 1);
        }
        if (this.verticalScroll > 0) {
            this.scroll(-1);
        }
        this.recalculateMaxWidth();
    }

    public void writeText(char c) {
        int prevCursorY = this.cursorY;
        this.writeText(Character.toString(c));
        if (this.wrapText && prevCursorY != this.cursorY) {
            this.moveCursorRight(1);
        }
    }

    public void writeText(String text) {
        text = text.replace("\r", "");
        String activeLine = this.getActiveLine();
        String head = activeLine.substring(0, this.cursorX);
        String tail = activeLine.substring(this.cursorX);
        if (this.wrapText) {
            if (text.endsWith("\n")) {
                String result = head + text;
                if (this.font.method_1727(result) > this.width - this.padding * 2) {
                    String trimmed = this.font.method_27523(result, this.width - this.padding * 2);
                    this.lines.set(this.cursorY, trimmed);
                    this.prependToLine(this.cursorY + 1, result.substring(trimmed.length()));
                } else {
                    this.lines.set(this.cursorY, result);
                }
                this.prependToLine(this.cursorY + 1, tail);
            } else {
                String result = head + text + tail;
                if (this.font.method_1727(result) > this.width - this.padding * 2) {
                    String trimmed = this.font.method_27523(result, this.width - this.padding * 2);
                    this.lines.set(this.cursorY, trimmed);
                    this.prependToLine(this.cursorY + 1, result.substring(trimmed.length()));
                } else {
                    this.lines.set(this.cursorY, result);
                }
            }
        } else if (text.endsWith("\n")) {
            this.lines.set(this.cursorY, head + text);
            this.prependToLine(this.cursorY + 1, tail);
        } else {
            this.lines.set(this.cursorY, head + text + tail);
        }
        this.moveCursorRight(text.length());
        this.recalculateMaxWidth();
    }

    private void prependToLine(int lineIndex, String text) {
        if (lineIndex == this.lines.size()) {
            this.lines.add("");
        }
        if (text.length() <= 0) {
            return;
        }
        if (lineIndex < this.lines.size()) {
            if (text.charAt(Math.max(0, text.length() - 1)) == '\n') {
                this.lines.add(lineIndex, text);
                return;
            }
            String result = text + this.lines.get(lineIndex);
            if (this.font.method_1727(result) > this.width - this.padding * 2) {
                String trimmed = this.font.method_27523(result, this.width - this.padding * 2);
                this.lines.set(lineIndex, trimmed);
                this.prependToLine(lineIndex + 1, result.substring(trimmed.length()));
            } else {
                this.lines.set(lineIndex, result);
            }
        }
    }

    public void moveCursorRight(int amount) {
        if (amount <= 0) {
            return;
        }
        String activeLine = this.getActiveLine();
        if (this.cursorY == this.lines.size() - 1 && this.cursorX == activeLine.length() || this.cursorX > 0 && activeLine.charAt(this.cursorX - 1) == '\n') {
            return;
        }
        this.cursorTick = 0;
        if (this.cursorX < activeLine.length() && activeLine.charAt(this.cursorX) != '\n') {
            ++this.cursorX;
        } else if (this.cursorY + 1 < this.lines.size()) {
            this.cursorX = 0;
            if (this.cursorY >= this.verticalScroll + this.visibleLines - 1) {
                this.scroll(1);
            }
            this.moveYCursor(1);
        }
        this.moveCursorRight(amount - 1);
    }

    public void moveCursorLeft(int amount) {
        if (amount <= 0) {
            return;
        }
        if (this.cursorX == 0 && this.cursorY == 0) {
            return;
        }
        this.cursorTick = 0;
        if (this.cursorX > 0) {
            --this.cursorX;
        } else {
            this.cursorX = this.lines.get(this.cursorY - 1).length();
            if (this.cursorX > 0 && this.lines.get(this.cursorY - 1).charAt(this.cursorX - 1) == '\n') {
                --this.cursorX;
            }
            if (this.cursorY - 1 < this.verticalScroll) {
                this.scroll(-1);
            }
            this.moveYCursor(-1);
        }
        this.moveCursorLeft(amount - 1);
    }

    private void moveCursorUp() {
        if (this.cursorY == 0) {
            return;
        }
        this.cursorTick = 0;
        String previousLine = this.lines.get(this.cursorY - 1);
        if (this.cursorX >= previousLine.length()) {
            this.cursorX = previousLine.length();
            if (previousLine.contains("\n")) {
                --this.cursorX;
            }
        }
        if (this.cursorY - 1 < this.verticalScroll) {
            this.scroll(-1);
        }
        this.moveYCursor(-1);
    }

    private void moveCursorDown() {
        if (this.cursorY == this.lines.size() - 1) {
            return;
        }
        this.cursorTick = 0;
        String nextLine = this.lines.get(this.cursorY + 1);
        if (this.cursorX > nextLine.length()) {
            this.cursorX = nextLine.length();
            if (nextLine.endsWith("\n")) {
                --this.cursorX;
            }
        }
        if (this.cursorY + 1 >= this.verticalScroll + this.visibleLines) {
            this.scroll(1);
        }
        this.moveYCursor(1);
    }

    private void moveYCursor(int amount) {
        this.cursorY += amount;
        if (this.cursorY < 0) {
            this.cursorY = 0;
            this.cursorX = 0;
        }
        if (this.cursorY >= this.lines.size()) {
            this.cursorX = this.lines.get(this.lines.size() - 1).length();
            this.cursorY = this.lines.size() - 1;
        }
    }

    private void scroll(int amount) {
        this.verticalScroll += amount;
        if (this.verticalScroll < 0) {
            this.verticalScroll = 0;
        } else if (this.verticalScroll > this.lines.size() - this.visibleLines) {
            this.verticalScroll = Math.max(0, this.lines.size() - this.visibleLines);
        }
    }

    private void updateText() {
        ArrayList<String> updatedLines = new ArrayList<String>();
        if (this.wrapText) {
            for (int i = 0; i < this.lines.size() - 1; ++i) {
                String line = this.lines.get(i);
                if (line.equals("\n")) {
                    updatedLines.add(line);
                    continue;
                }
                List<String> split = this.font.method_27523(this.lines.get(i), this.width - this.padding * 2).lines().toList();
                for (int j = 0; j < split.size() - 1; ++j) {
                    updatedLines.add(split.get(j));
                }
                if (split.size() <= 0) continue;
                updatedLines.add(split.get(split.size() - 1) + "\n");
            }
            List<String> split = this.font.method_27523(this.lines.get(this.lines.size() - 1), this.width - this.padding * 2).lines().toList();
            for (int i = 0; i < split.size() - 1; ++i) {
                updatedLines.add(split.get(i));
            }
            if (split.size() > 0) {
                updatedLines.add(split.get(split.size() - 1));
            }
            List<String> activeLine = this.font.method_27523(this.lines.get(this.cursorY), this.width - this.padding * 2).lines().toList();
            int totalLength = 0;
            for (String line : activeLine) {
                if (totalLength + line.length() < this.cursorX) {
                    totalLength += line.length();
                    ++this.cursorY;
                    continue;
                }
                this.cursorX -= totalLength;
                break;
            }
        } else {
            int totalLength = 0;
            int lineIndex = 0;
            StringBuilder builder = new StringBuilder();
            do {
                String line = this.lines.get(lineIndex);
                if (totalLength > 0) {
                    builder.append(" ");
                }
                builder.append(line);
                if (lineIndex == this.cursorY) {
                    this.cursorX += totalLength;
                    this.cursorY = updatedLines.size();
                } else {
                    totalLength += line.length();
                }
                if (!line.endsWith("\n")) {
                    if (lineIndex != this.lines.size() - 1) continue;
                    updatedLines.add(builder.toString());
                    break;
                }
                updatedLines.add(builder.toString());
                builder.setLength(0);
                totalLength = 0;
            } while (++lineIndex < this.lines.size());
        }
        this.lines = updatedLines;
        this.recalculateMaxWidth();
    }

    private void updateScroll() {
        if (!this.wrapText) {
            int visibleWidth = this.width - this.padding * 2;
            int textWidth = this.font.method_1727(this.lines.get(this.cursorY).substring(0, this.cursorX));
            if (textWidth < this.horizontalScroll) {
                this.horizontalScroll = Math.max(0, textWidth - 1);
            } else if (textWidth > this.horizontalScroll + visibleWidth) {
                this.horizontalScroll = Math.max(0, textWidth - visibleWidth + 1);
            } else if (this.cursorX == 0) {
                this.horizontalScroll = 0;
            }
        }
        if (this.cursorY < this.verticalScroll) {
            this.verticalScroll = Math.min(Math.max(0, this.cursorY - 1), Math.max(0, this.lines.size() - this.visibleLines));
        } else if (this.cursorY >= this.verticalScroll + this.visibleLines) {
            this.verticalScroll = Math.max(0, Math.min(this.cursorY + 1 - (this.visibleLines - 1), this.lines.size() - this.visibleLines));
        }
    }

    private void recalculateMaxWidth() {
        int maxWidth = 0;
        for (String line : this.lines) {
            if (this.font.method_1727(line) <= maxWidth) continue;
            maxWidth = this.font.method_1727(line);
        }
        this.maxLineWidth = maxWidth;
    }

    private int getClosestLineIndex(int lineX, int lineY) {
        int nextDistanceX;
        String line = this.lines.get(lineY);
        int clickedCharX = this.font.method_27523(line, lineX).length();
        int nextCharX = class_3532.method_15340((int)(clickedCharX + 1), (int)0, (int)line.length());
        int clickedCharWidth = this.font.method_1727(line.substring(0, clickedCharX));
        int nextCharWidth = this.font.method_1727(line.substring(0, nextCharX));
        int clickedDistanceX = Math.abs(clickedCharWidth - lineX);
        int charX = Math.min(clickedDistanceX, nextDistanceX = Math.abs(nextCharWidth - lineX - 1)) == clickedDistanceX ? clickedCharX : nextCharX;
        if (charX > 0 && this.lines.get(lineY).charAt(charX - 1) == '\n') {
            --charX;
        }
        return charX;
    }

    public void clear() {
        this.cursorX = 0;
        this.cursorY = 0;
        this.lines.clear();
        this.lines.add("");
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            builder.append(this.lines.get(i));
        }
        builder.append(this.lines.get(this.lines.size() - 1));
        return builder.toString();
    }

    public void setText(String text) {
        this.lines.clear();
        String[] splitText = text.replace("\r", "").split("\n");
        for (int i = 0; i < splitText.length - 1; ++i) {
            this.lines.add(splitText[i] + "\n");
        }
        this.lines.add(splitText[splitText.length - 1]);
        this.cursorX = splitText[splitText.length - 1].length();
        this.cursorY = splitText.length - 1;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
        this.horizontalScroll = 0;
        this.updateText();
    }

    public void setScrollBarVisible(boolean scrollBarVisible) {
        this.scrollBarVisible = scrollBarVisible;
    }

    public void setScrollBarSize(int scrollBarSize) {
        this.scrollBarSize = Math.max(0, scrollBarSize);
    }

    public void setHighlight(IHighlight highlight) {
        this.highlight = highlight;
    }

    public void setFocused(boolean isFocused) {
        this.isFocused = isFocused;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        Objects.requireNonNull(this.font);
        this.visibleLines = (int)Math.floor((this.height - padding * 2) / 9);
    }

    public void setTextColor(Color color) {
        this.textColor = color.getRGB();
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color.getRGB();
    }

    public Color getBackgroundColor() {
        return new Color(this.backgroundColor);
    }

    public int getBackgroundColorRGB() {
        return this.backgroundColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color.getRGB();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setMaxLines(int maxLines) {
        if (maxLines < 0) {
            maxLines = 0;
        }
        this.maxLines = maxLines;
    }

    public void setKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    static {
        StringJoiner joiner = new StringJoiner("|");
        for (String s : DELIMITERS) {
            joiner.add(s);
        }
        SPLIT_REGEX = String.format(UNFORMATTED_SPLIT, "(" + joiner + ")");
    }

    private static enum ScrollBar {
        HORIZONTAL,
        VERTICAL;

    }
}

