/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.io;

import com.ultreon.devices.api.io.Folder;
import com.ultreon.devices.core.io.FileSystem;
import java.util.UUID;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class Drive {
    private final String name;
    private final UUID uuid;
    private final Type type;
    private Folder root;
    private boolean synced = false;

    public Drive(class_2487 driveTag) {
        this.name = driveTag.method_10558("name");
        this.uuid = UUID.fromString(driveTag.method_10558("uuid"));
        this.type = Type.fromString(driveTag.method_10558("type"));
    }

    public String getName() {
        return this.name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Type getType() {
        return this.type;
    }

    public Folder getRoot() {
        return this.root;
    }

    public void syncRoot(Folder root) {
        if (!this.synced) {
            this.root = root;
            root.setDrive(this);
            root.validate();
            this.synced = true;
        }
    }

    public boolean isSynced() {
        return this.synced;
    }

    @Nullable
    public final Folder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        if (path.equals("/")) {
            return this.root;
        }
        Folder prev = this.root;
        String[] folders = path.split("/");
        if (folders.length > 0 && folders.length <= 10) {
            for (int i = 1; i < folders.length; ++i) {
                Folder temp = prev.getFolder(folders[i]);
                if (temp == null) {
                    return null;
                }
                prev = temp;
            }
            return prev;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK,
        UNKNOWN;


        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.toString().equals(type)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

