/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.print;

import com.google.common.collect.HashBiMap;
import com.ultreon.devices.Devices;
import com.ultreon.devices.api.print.IPrint;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

public class PrintingManager {
    private static final HashBiMap<String, Class<? extends IPrint>> registeredPrints = HashBiMap.create();
    @Environment(value=EnvType.CLIENT)
    private static Map<String, IPrint.Renderer> registeredRenders;

    @PlatformOnly(value={"fabric"})
    public static Map<String, IPrint.Renderer> getRegisteredRenders() {
        return registeredRenders;
    }

    @PlatformOnly(value={"fabric"})
    public static void setRegisteredRenders(Map<String, IPrint.Renderer> registeredRenders) {
        PrintingManager.registeredRenders = registeredRenders;
    }

    public static void registerPrint(class_2960 identifier, Class<? extends IPrint> classPrint) {
        try {
            classPrint.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (Devices.registerPrint(identifier, classPrint)) {
                Devices.LOGGER.info("Registering print '" + classPrint.getName() + "'");
                registeredPrints.put((Object)identifier.toString(), classPrint);
            } else {
                Devices.LOGGER.error("The print '" + classPrint.getName() + "' could not be registered due to a critical error!");
            }
        }
        catch (NoSuchMethodException e) {
            Devices.LOGGER.error("The print '" + classPrint.getName() + "' is missing an empty constructor and could not be registered!");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Devices.LOGGER.error("The print '" + classPrint.getName() + "' could not be registered due to a critical error!");
        }
    }

    public static boolean isRegisteredPrint(Class<? extends IPrint> clazz) {
        return registeredPrints.containsValue(clazz);
    }

    @Nullable
    public static IPrint getPrint(String identifier) {
        Class clazz = (Class)registeredPrints.get((Object)identifier);
        if (clazz != null) {
            try {
                return (IPrint)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static IPrint.Renderer getRenderer(IPrint print) {
        String id = PrintingManager.getPrintIdentifier(print);
        return registeredRenders.get(id);
    }

    @Environment(value=EnvType.CLIENT)
    public static IPrint.Renderer getRenderer(String identifier) {
        return registeredRenders.get(identifier);
    }

    public static String getPrintIdentifier(IPrint print) {
        return (String)registeredPrints.inverse().get(print.getClass());
    }
}

