/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.utils;

import com.ultreon.devices.util.StreamUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public class OnlineRequest {
    private static OnlineRequest instance = null;
    private final Queue<RequestWrapper> requests = new ConcurrentLinkedQueue<RequestWrapper>();
    private Thread thread;
    private volatile boolean running = true;

    private OnlineRequest() {
        this.start();
    }

    public static OnlineRequest getInstance() {
        if (instance == null) {
            instance = new OnlineRequest();
        }
        return instance;
    }

    public static void checkURLForSuspicions(URL url) throws IOException {
        System.out.println(url.getHost());
        if (!OnlineRequest.isSafe(url.getHost())) {
            throw new IOException();
        }
    }

    private static boolean isSafe(String host) {
        return switch (host) {
            case "ultreon.gitlab.io", "cdn.discordapp.com", "jab125.com", "raw.githubusercontent.com", "github.com", "i.imgur.com", "avatars1.githubusercontent.com" -> true;
            default -> false;
        };
    }

    private void start() {
        this.thread = new Thread((Runnable)new RequestRunnable(), "Online Request Thread");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void make(String url, ResponseHandler handler) {
        Queue<RequestWrapper> queue = this.requests;
        synchronized (queue) {
            this.requests.offer(new RequestWrapper(url, handler));
            this.requests.notify();
        }
    }

    public void stop() {
        this.running = false;
        this.thread.interrupt();
    }

    private class RequestRunnable
    implements Runnable {
        private RequestRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (OnlineRequest.this.running) {
                try {
                    Queue<RequestWrapper> queue = OnlineRequest.this.requests;
                    synchronized (queue) {
                        OnlineRequest.this.requests.wait();
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                while (!OnlineRequest.this.requests.isEmpty()) {
                    RequestWrapper wrapper = OnlineRequest.this.requests.poll();
                    try {
                        URL url = new URL(wrapper.url);
                        OnlineRequest.checkURLForSuspicions(url);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        wrapper.handler.handle(false, "DOMAIN NOT BLACKLISTED/ERROR PARSING DOMAIN");
                        continue;
                    }
                    try {
                        CloseableHttpClient client = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (chain, authType) -> true).build()).build();
                        try {
                            HttpGet get = new HttpGet(wrapper.url);
                            CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                            try {
                                String raw = StreamUtils.convertToString(response.getEntity().getContent());
                                wrapper.handler.handle(true, raw);
                            }
                            finally {
                                if (response == null) continue;
                                response.close();
                            }
                        }
                        finally {
                            if (client == null) continue;
                            client.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        wrapper.handler.handle(false, "");
                    }
                }
            }
        }
    }

    private record RequestWrapper(String url, ResponseHandler handler) {
    }

    public static interface ResponseHandler {
        public void handle(boolean var1, String var2);
    }
}

