/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.api.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.ultreon.devices.core.Laptop;
import com.ultreon.devices.object.AppInfo;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class RenderUtil {
    public static void renderItem(int x, int y, class_1799 stack, boolean overlay) {
        RenderSystem.disableDepthTest();
        class_308.method_24210();
        class_310.method_1551().method_1480().method_4023(stack, x, y);
        if (overlay) {
            class_310.method_1551().method_1480().method_4025(class_310.method_1551().field_1772, stack, x, y);
        }
    }

    public static void drawIcon(class_4587 pose, double x, double y, AppInfo info, int width, int height) {
        AppInfo.Icon.Glyph[] glyphs;
        RenderSystem.setShaderTexture((int)0, (class_2960)Laptop.ICON_TEXTURES);
        if (info == null || info.getIcon().getBase().getU() == -1 && info.getIcon().getBase().getV() == -1) {
            RenderUtil.drawRectWithTexture(pose, x, y, 0.0f, 0.0f, width, height, 14.0f, 14.0f, 224, 224);
            return;
        }
        RenderSystem.enableBlend();
        for (AppInfo.Icon.Glyph glyph : glyphs = new AppInfo.Icon.Glyph[]{info.getIcon().getBase(), info.getIcon().getOverlay0(), info.getIcon().getOverlay1()}) {
            if (glyph.getU() == -1 || glyph.getV() == -1) continue;
            Color col = new Color(info.getTint(glyph.getType()));
            int[] tint = new int[]{col.getRed(), col.getGreen(), col.getBlue()};
            RenderSystem.setShaderColor((float)((float)tint[0] / 255.0f), (float)((float)tint[1] / 255.0f), (float)((float)tint[2] / 255.0f), (float)1.0f);
            RenderUtil.drawRectWithTexture(pose, x, y, glyph.getU(), glyph.getV(), width, height, 14.0f, 14.0f, 224, 224);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRectWithTexture(class_4587 pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        RenderUtil.drawRectWithTexture(pose, x, y, 0.0, u, v, width, height, textureWidth, textureHeight);
    }

    public static void drawRectWithTexture(class_4587 pose, double x, double y, double z, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float scale = 0.00390625f;
        class_1159 e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        try {
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        }
        catch (IllegalStateException e_) {
            buffer.method_1326();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        }
        buffer.method_22918(e, (float)x, (float)(y + (double)height), (float)z).method_22913(u * scale, (v + textureHeight) * scale).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), (float)z).method_22913((u + textureWidth) * scale, (v + textureHeight) * scale).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)y, (float)z).method_22913((u + textureWidth) * scale, v * scale).method_1344();
        buffer.method_22918(e, (float)x, (float)y, (float)z).method_22913(u * scale, v * scale).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void drawRectWithFullTexture(class_4587 pose, double x, double y, float u, float v, int width, int height) {
        class_1159 e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float)x, (float)(y + (double)height), 0.0f).method_22913(0.0f, 1.0f).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).method_22913(1.0f, 1.0f).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)y, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        buffer.method_22918(e, (float)x, (float)y, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void drawRectWithTexture(class_4587 pose, double x, double y, float u, float v, int width, int height, float textureWidth, float textureHeight, int sourceWidth, int sourceHeight) {
        float scaleWidth = 1.0f / (float)sourceWidth;
        float scaleHeight = 1.0f / (float)sourceHeight;
        class_1159 e = pose.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(e, (float)x, (float)(y + (double)height), 0.0f).method_22913(u * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)(y + (double)height), 0.0f).method_22913((u + textureWidth) * scaleWidth, (v + textureHeight) * scaleHeight).method_1344();
        buffer.method_22918(e, (float)(x + (double)width), (float)y, 0.0f).method_22913((u + textureWidth) * scaleWidth, v * scaleHeight).method_1344();
        buffer.method_22918(e, (float)x, (float)y, 0.0f).method_22913(u * scaleWidth, v * scaleHeight).method_1344();
        class_286.method_43433((class_287.class_7433)buffer.method_1326());
    }

    public static void drawApplicationIcon(class_4587 pose, @Nullable AppInfo info, double x, double y) {
        RenderSystem.setShaderTexture((int)0, (class_2960)Laptop.ICON_TEXTURES);
        if (info != null) {
            RenderUtil.drawIcon(pose, x, y, info, 14, 14);
        } else {
            RenderUtil.drawRectWithTexture(pose, x, y, 0.0f, 0.0f, 14, 14, 14.0f, 14.0f, 224, 224);
        }
    }

    public static void drawStringClipped(class_4587 pose, String text, int x, int y, int width, int color, boolean shadow) {
        if (shadow) {
            Laptop.getFont().method_1720(pose, RenderUtil.clipStringToWidth(text, width) + class_124.field_1070, (float)x, (float)y, color);
        } else {
            Laptop.getFont().method_1729(pose, Laptop.getFont().method_27523(text, width) + class_124.field_1070, (float)x, (float)y, color);
        }
    }

    public static String clipStringToWidth(String text, int width) {
        Object clipped;
        class_327 fontRenderer = Laptop.getFont();
        if (fontRenderer.method_1727((String)(clipped = text)) > width) {
            clipped = fontRenderer.method_27523((String)clipped, width - 8) + "...";
        }
        return clipped;
    }

    public static boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public static int color(int color, int defaultColor) {
        return color > 0 ? color : defaultColor;
    }
}

