/*
 * Decompiled with CFR 0.152.
 */
package com.ultreon.devices.block.entity;

import com.ultreon.devices.block.LaptopBlock;
import com.ultreon.devices.block.entity.NetworkDeviceBlockEntity;
import com.ultreon.devices.core.io.FileSystem;
import com.ultreon.devices.init.DeviceBlockEntities;
import com.ultreon.devices.util.BlockEntityUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaptopBlockEntity
extends NetworkDeviceBlockEntity.Colored {
    private static final int OPENED_ANGLE = 102;
    private boolean open = false;
    private class_2487 applicationData = new class_2487();
    private class_2487 systemData = new class_2487();
    private FileSystem fileSystem;
    @Environment(value=EnvType.CLIENT)
    private int rotation;
    @Environment(value=EnvType.CLIENT)
    private int prevRotation;
    private class_1767 externalDriveColor;

    public LaptopBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super((class_2591)DeviceBlockEntities.LAPTOP.get(), pWorldPosition, pBlockState);
    }

    @Override
    public String getDeviceName() {
        return "Laptop";
    }

    @Override
    public void tick() {
        super.tick();
        assert (this.field_11863 != null);
        if (this.field_11863.field_9236) {
            this.prevRotation = this.rotation;
            if (!this.open) {
                if (this.rotation > 0) {
                    this.rotation -= 10;
                }
            } else if (this.rotation < 102) {
                this.rotation += 10;
            }
        }
    }

    @Override
    public void method_11014(@NotNull class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("open")) {
            this.open = compound.method_10577("open");
            this.method_11010().method_11657((class_2769)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open));
        }
        if (compound.method_10573("system_data", 10)) {
            this.systemData = compound.method_10562("system_data");
        }
        if (compound.method_10573("application_data", 10)) {
            this.applicationData = compound.method_10562("application_data");
        }
        if (compound.method_10545("file_system")) {
            this.fileSystem = new FileSystem(this, compound.method_10562("file_system"));
        }
        if (compound.method_10573("external_drive_color", 1)) {
            this.externalDriveColor = null;
            if (compound.method_10571("external_drive_color") != -1) {
                this.externalDriveColor = class_1767.method_7791((int)compound.method_10571("external_drive_color"));
            }
        }
    }

    @Override
    public void method_11007(@NotNull class_2487 compound) {
        super.method_11007(compound);
        compound.method_10556("open", this.open);
        if (this.systemData != null) {
            compound.method_10566("system_data", (class_2520)this.systemData);
        }
        if (this.applicationData != null) {
            compound.method_10566("application_data", (class_2520)this.applicationData);
        }
        if (this.fileSystem != null) {
            compound.method_10566("file_system", (class_2520)this.fileSystem.toTag());
        }
    }

    @Override
    public class_2487 saveSyncTag() {
        class_2487 tag = super.saveSyncTag();
        tag.method_10556("open", this.open);
        tag.method_10566("system_data", (class_2520)this.getSystemData());
        if (this.getFileSystem().getAttachedDrive() != null) {
            tag.method_10567("external_drive_color", (byte)this.getFileSystem().getAttachedDriveColor().method_7789());
        } else {
            tag.method_10567("external_drive_color", (byte)-1);
        }
        return tag;
    }

    public void openClose(@Nullable class_1297 entity) {
        class_1937 level = this.field_11863;
        if (level != null) {
            level.method_43276(!this.open ? class_5712.field_28168 : class_5712.field_28169, this.method_11016(), class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
        }
        boolean oldOpen = this.open;
        boolean bl = this.open = (Boolean)this.method_11010().method_11654((class_2769)LaptopBlock.OPEN) == false;
        if (oldOpen != this.open) {
            this.pipeline.method_10556("open", this.open);
            class_2680 d = (class_2680)this.method_11010().method_11657((class_2769)LaptopBlock.OPEN, (Comparable)Boolean.valueOf(this.open));
            this.field_11863.method_8652(this.method_11016(), d, 18);
            this.sync();
        }
        if (level != null) {
            this.markUpdated();
            LaptopBlockEntity.doNeighborUpdates(level, this.method_11016(), this.method_11010());
        }
    }

    private static void doNeighborUpdates(class_1937 level, class_2338 pos, class_2680 state) {
        state.method_30101((class_1936)level, pos, 3);
    }

    public boolean isOpen() {
        return this.open;
    }

    public class_2487 getApplicationData() {
        return this.applicationData != null ? this.applicationData : new class_2487();
    }

    public class_2487 getSystemData() {
        if (this.systemData == null) {
            this.systemData = new class_2487();
        }
        return this.systemData;
    }

    public void setSystemData(class_2487 systemData) {
        this.systemData = systemData;
        this.method_5431();
        assert (this.field_11863 != null);
        BlockEntityUtil.markBlockForUpdate(this.field_11863, this.field_11867);
    }

    public FileSystem getFileSystem() {
        if (this.fileSystem == null) {
            this.fileSystem = new FileSystem(this, new class_2487());
        }
        return this.fileSystem;
    }

    public void setApplicationData(String appId, class_2487 applicationData) {
        this.applicationData = applicationData;
        this.method_5431();
        assert (this.field_11863 != null);
        BlockEntityUtil.markBlockForUpdate(this.field_11863, this.field_11867);
    }

    @Environment(value=EnvType.CLIENT)
    public float getScreenAngle(float partialTicks) {
        return -102.0f * (((float)this.prevRotation + (float)(this.rotation - this.prevRotation) * partialTicks) / 102.0f);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isExternalDriveAttached() {
        return this.externalDriveColor != null;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1767 getExternalDriveColor() {
        return this.externalDriveColor;
    }
}

